/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import java.awt.Color;
import java.awt.Font;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public final class CompSettings {
    private static final Logger log = Logger.getLogger(CompSettings.class);
    public static final Color errorBackground = Color.pink;
    public static final Font smallFontDefault = new Font("dialog", 0, 10);

    private CompSettings() {
    }

    public static void syncWithSwing(Runnable runner) {
        if (runner == null) {
            throw new IllegalArgumentException("Argument was null");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    public static void dispatchEvent(final Runnable runner) {
        if (runner == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            Thread waitThread = new Thread(){

                @Override
                public void run() {
                    try {
                        SwingUtilities.invokeAndWait(runner);
                    }
                    catch (Throwable e) {
                        log.error((Object)"Exception in invokeAndWait", e);
                    }
                }
            };
            waitThread.start();
            try {
                waitThread.join(2000L);
                if (waitThread.isAlive()) {
                    SwingUtilities.invokeLater(runner);
                }
            }
            catch (Throwable e) {
                log.error((Object)"Exception while waiting for SwingUtilities.invokeAndWait", e);
            }
        }
    }

    public static String getDateString() {
        return CompSettings.getDefaultDateFormat().format(new Date());
    }

    public static DateFormat getDefaultDateFormat() {
        return new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.ENGLISH);
    }

    public static DateFormat getSimpleDateFormat() {
        return new SimpleDateFormat("HH:mm:ss", Locale.ENGLISH);
    }
}

