/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import java.util.RandomAccess;

public class BooleanList
extends AbstractList<Boolean>
implements Serializable,
RandomAccess {
    private static final long serialVersionUID = 653930294509274337L;
    private boolean[] array;
    private int end;

    private BooleanList(boolean[] array, int end) {
        this.array = array;
        this.end = end;
    }

    @Override
    public void clear() {
        this.end = 0;
    }

    public BooleanList() {
        this(10);
    }

    public BooleanList(int capacity) {
        this(new boolean[capacity], 0);
    }

    public BooleanList(Collection<Boolean> c) {
        this(c.size());
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.end;
    }

    @Override
    public boolean add(boolean e) {
        this.enlageIfNeeded(1);
        this.array[this.end] = e;
        this.increasedSize(1);
        return true;
    }

    public boolean push(boolean e) {
        this.add(e);
        return e;
    }

    public boolean pop() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.removeB(this.size() - 1);
    }

    public boolean peek() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.get(this.size() - 1);
    }

    private void decreaseSize(int removed) {
        this.end -= removed;
    }

    private void increasedSize(int added) {
        this.end += added;
    }

    private void boundsCheck(int index) throws IndexOutOfBoundsException {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("List is of size " + this.size() + ", index requested " + index);
        }
    }

    private void enlageIfNeeded(int i) {
        while (this.end + i > this.array.length) {
            this.array = Arrays.copyOf(this.array, Math.max(this.array.length * 2, 8));
        }
    }

    @Override
    public boolean add(Boolean e) {
        if (e == null) {
            return false;
        }
        return this.add((boolean)e);
    }

    public boolean getB(int index) {
        this.boundsCheck(index);
        return this.array[index];
    }

    @Override
    public Boolean get(int index) {
        return this.getB(index);
    }

    @Override
    public boolean set(int index, boolean element) {
        this.boundsCheck(index);
        boolean ret = this.get(index);
        this.array[index] = element;
        return ret;
    }

    @Override
    public Boolean set(int index, Boolean element) {
        return this.set(index, (boolean)element);
    }

    @Override
    public void add(int index, boolean element) {
        if (index == this.size()) {
            this.add(element);
        } else {
            this.boundsCheck(index);
            this.enlageIfNeeded(1);
            System.arraycopy(this.array, index, this.array, index + 1, this.size() - index);
            this.set(index, element);
            this.increasedSize(1);
        }
    }

    @Override
    public void add(int index, Boolean element) {
        this.add(index, (boolean)element);
    }

    public boolean removeB(int index) {
        this.boundsCheck(index);
        boolean ret = this.array[index];
        for (int i = index; i < this.end - 1; ++i) {
            this.array[i] = this.array[i + 1];
        }
        this.decreaseSize(1);
        return ret;
    }

    @Override
    public Boolean remove(int index) {
        return this.removeB(index);
    }

    public boolean[] getBackingArray() {
        return this.array;
    }

    public static List<Boolean> unmodifiableView(boolean[] array, int length) {
        return Collections.unmodifiableList(BooleanList.view(array, length));
    }

    public static BooleanList view(boolean[] array, int length) {
        if (length > array.length || length < 0) {
            throw new IllegalArgumentException("length must be non-negative and no more than the size of the array(" + array.length + "), not " + length);
        }
        return new BooleanList(array, length);
    }
}

