/*
 * Decompiled with CFR 0.152.
 */
package jsat.outlier;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.linear.DenseVector;
import jsat.linear.ScaledVector;
import jsat.linear.Vec;
import jsat.math.optimization.stochastic.AdaGrad;
import jsat.outlier.Outlier;
import jsat.utils.random.RandomUtil;

public class LinearOCSVM
implements Outlier {
    private Vec w;
    private double p;
    private int max_epochs = 100;
    private double learningRate = 0.01;
    private double v = 0.05;

    public void setV(double v) {
        this.v = v;
    }

    public double getV() {
        return this.v;
    }

    @Override
    public void fit(DataSet d, boolean parallel) {
        Random rand = RandomUtil.getRandom();
        List<Vec> X = d.getDataVectors();
        int N = X.size();
        this.w = new ScaledVector(new DenseVector(X.get(0).length()));
        this.p = 0.0;
        AdaGrad gu = new AdaGrad();
        gu.setup(this.w.length());
        double cnt = 1.0 / this.v;
        double prevLoss = Double.POSITIVE_INFINITY;
        double curLoss = Double.POSITIVE_INFINITY;
        for (int epoch = 0; epoch < this.max_epochs; ++epoch) {
            Collections.shuffle(X, rand);
            prevLoss = curLoss;
            curLoss = 0.0;
            for (int i = 0; i < X.size(); ++i) {
                Vec x = X.get(i);
                double loss = this.p - this.w.dot(x);
                double p_delta = -1.0;
                double x_mul = 0.0;
                if (loss > 0.0) {
                    p_delta += 1.0 * cnt;
                    x_mul = -1.0 * cnt;
                }
                curLoss += Math.max(0.0, loss);
                this.p -= gu.update(this.w, new ScaledVector(x_mul, x), this.learningRate, this.p, p_delta);
                this.w.mutableMultiply(1.0 - this.learningRate);
            }
            if (Math.abs((curLoss - prevLoss) / (double)N) < 1.0E-6 * this.v) break;
        }
    }

    @Override
    public double score(DataPoint x) {
        return this.w.dot(x.getNumericalValues()) - this.p;
    }
}

