/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.integration;

import jsat.math.Function1D;

public class AdaptiveSimpson {
    public static double integrate(Function1D f, double tol, double a, double b) {
        return AdaptiveSimpson.integrate(f, tol, a, b, 100);
    }

    public static double integrate(Function1D f, double tol, double a, double b, int maxDepth) {
        if (a == b) {
            return 0.0;
        }
        if (a > b) {
            throw new RuntimeException("Integral upper limit (" + b + ") must be larger than the lower-limit (" + a + ")");
        }
        double h = b - a;
        double c = (a + b) / 2.0;
        double f_a = f.f(a);
        double f_b = f.f(b);
        double f_c = f.f(c);
        double one_simpson = h * (f_a + 4.0 * f_c + f_b) / 6.0;
        double d = (a + c) / 2.0;
        double e = (c + b) / 2.0;
        double two_simpson = h * (f_a + 4.0 * f.f(d) + 2.0 * f_c + 4.0 * f.f(e) + f_b) / 12.0;
        if (maxDepth <= 0) {
            return two_simpson;
        }
        if (Math.abs(one_simpson - two_simpson) < 15.0 * tol) {
            return two_simpson + (two_simpson - one_simpson) / 15.0;
        }
        double left_simpson = AdaptiveSimpson.integrate(f, tol / 2.0, a, c, maxDepth - 1);
        double right_simpson = AdaptiveSimpson.integrate(f, tol / 2.0, c, b, maxDepth - 1);
        return left_simpson + right_simpson;
    }
}

