/*
 * Decompiled with CFR 0.152.
 */
package jsat.math;

public abstract class ContinuedFraction {
    public abstract double getA(int var1, double ... var2);

    public abstract double getB(int var1, double ... var2);

    public double backwardNaive(int n, double ... args) {
        double term = this.getA(n, args) / this.getB(n, args);
        --n;
        while (n > 0) {
            term = this.getA(n, args) / (this.getB(n, args) + term);
            --n;
        }
        return term + this.getB(0, args);
    }

    public double lentz(double ... args) {
        double f_n = this.getB(0, args);
        if (f_n == 0.0) {
            f_n = 1.0E-30;
        }
        double c_0 = f_n;
        double d_0 = 0.0;
        double delta = 0.0;
        int j = 0;
        while (Math.abs(delta - 1.0) > 1.0E-15) {
            double c_n;
            double d_n;
            if ((d_n = this.getB(++j, args) + this.getA(j, args) * d_0) == 0.0) {
                d_n = 1.0E-30;
            }
            if ((c_n = this.getB(j, args) + this.getA(j, args) / c_0) == 0.0) {
                c_n = 1.0E-30;
            }
            d_n = 1.0 / d_n;
            delta = c_n * d_n;
            f_n *= delta;
            d_0 = d_n;
            c_0 = c_n;
        }
        return f_n;
    }
}

