/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.IncrementalCollection;
import jsat.linear.vectorcollection.IndexDistPair;
import jsat.utils.BoundedSortedList;
import jsat.utils.DoubleList;
import jsat.utils.IndexTable;
import jsat.utils.IntList;
import jsat.utils.ListUtils;
import jsat.utils.concurrent.ParallelUtils;

public class RandomBallCover<V extends Vec>
implements IncrementalCollection<V> {
    private static final long serialVersionUID = 2437771973228849200L;
    private DistanceMetric dm;
    private List<List<Integer>> ownedVecs;
    private List<DoubleList> ownedRDists;
    private List<Integer> R;
    private int size;
    private List<V> allVecs;
    private List<Double> distCache;
    private double[] repRadius;

    public RandomBallCover(List<V> vecs, DistanceMetric dm, boolean parallel) {
        this.dm = dm;
        this.build(parallel, vecs, dm);
    }

    public RandomBallCover(List<V> vecs, DistanceMetric dm) {
        this(vecs, dm, false);
    }

    public RandomBallCover(DistanceMetric dm) {
        this.dm = dm;
        this.size = 0;
        this.allVecs = new ArrayList<V>();
        if (dm.supportsAcceleration()) {
            this.distCache = new DoubleList();
        }
        this.R = new IntList();
    }

    public RandomBallCover() {
        this(new EuclideanDistance());
    }

    private RandomBallCover(RandomBallCover<V> other) {
        this.dm = other.dm.clone();
        this.size = other.size;
        if (other.allVecs != null) {
            this.allVecs = new ArrayList<V>(other.allVecs);
        }
        if (other.distCache != null) {
            this.distCache = new DoubleList(other.distCache);
        }
        if (other.ownedVecs != null) {
            this.ownedVecs = new ArrayList<List<Integer>>(other.ownedVecs.size());
        }
        if (other.ownedRDists != null) {
            this.ownedRDists = new ArrayList<DoubleList>(other.ownedRDists.size());
        }
        if (other.ownedRDists != null) {
            for (int i = 0; i < other.ownedRDists.size(); ++i) {
                this.ownedRDists.add(new DoubleList(other.ownedRDists.get(i)));
                this.ownedVecs.add(new IntList((Collection<Integer>)other.ownedVecs.get(i)));
            }
        }
        this.R = new IntList(other.R);
        if (other.repRadius != null) {
            this.repRadius = Arrays.copyOf(other.repRadius, other.repRadius.length);
        }
    }

    @Override
    public void build(boolean parallel, List<V> collection, DistanceMetric dm) {
        this.setDistanceMetric(dm);
        this.size = collection.size();
        this.allVecs = new ArrayList<V>(collection);
        this.distCache = dm.getAccelerationCache(this.allVecs, parallel);
        IntList allIndices = new IntList(this.allVecs.size());
        ListUtils.addRange(allIndices, 0, this.size, 1);
        this.setUp(allIndices, parallel);
    }

    @Override
    public List<Double> getAccelerationCache() {
        return this.distCache;
    }

    private void setUp(List<Integer> vecIndices, boolean parallel) {
        int repCount = (int)Math.max(1.0, Math.sqrt(vecIndices.size()));
        Collections.shuffle(vecIndices);
        this.R = new IntList(vecIndices.subList(0, repCount));
        this.repRadius = new double[this.R.size()];
        this.ownedRDists = new ArrayList<DoubleList>(this.repRadius.length);
        IntList vecIndicesSub = new IntList(vecIndices.subList(repCount, vecIndices.size()));
        this.ownedVecs = new ArrayList<List<Integer>>(repCount);
        for (int i = 0; i < repCount; ++i) {
            this.ownedVecs.add(new IntList(repCount));
            this.ownedRDists.add(new DoubleList(repCount));
        }
        ParallelUtils.run(parallel, vecIndicesSub.size(), (start, end) -> {
            Iterator iterator = vecIndicesSub.subList(start, end).iterator();
            while (iterator.hasNext()) {
                int v = (Integer)iterator.next();
                int bestRep = 0;
                double bestDist = this.dm.dist(v, this.R.get(0), this.allVecs, this.distCache);
                for (int potentialRep = 1; potentialRep < this.R.size(); ++potentialRep) {
                    double d;
                    double tmp = this.dm.dist(v, this.R.get(potentialRep), this.allVecs, this.distCache);
                    if (!(d < bestDist)) continue;
                    bestDist = tmp;
                    bestRep = potentialRep;
                }
                List<Integer> list = this.ownedVecs.get(bestRep);
                synchronized (list) {
                    this.ownedVecs.get(bestRep).add(v);
                    this.ownedRDists.get(bestRep).add(bestDist);
                    this.repRadius[bestRep] = Math.max(this.repRadius[bestRep], bestDist);
                }
            }
        });
    }

    @Override
    public void search(Vec query, double range, List<Integer> neighbors, List<Double> distances) {
        neighbors.clear();
        distances.clear();
        List<Double> qi = this.dm.getQueryInfo(query);
        if (this.repRadius == null) {
            for (int i = 0; i < this.allVecs.size(); ++i) {
                double dist = this.dm.dist(i, query, qi, this.allVecs, this.distCache);
                if (!(dist <= range)) continue;
                distances.add(dist);
                neighbors.add(i);
            }
            return;
        }
        double[] queryRDists = new double[this.R.size()];
        for (int i = 0; i < this.R.size(); ++i) {
            double d;
            queryRDists[i] = this.dm.dist(this.R.get(i), query, qi, this.allVecs, this.distCache);
            if (!(d <= range)) continue;
            neighbors.add(this.R.get(i));
            distances.add(queryRDists[i]);
        }
        IndexTable sorted = new IndexTable(queryRDists);
        for (int i_indx = 0; i_indx < this.R.size(); ++i_indx) {
            int i = sorted.index(i_indx);
            if (queryRDists[i] > range + this.repRadius[i]) continue;
            for (int j = 0; j < this.ownedVecs.get(i).size(); ++j) {
                double d;
                double rDist = this.ownedRDists.get(i).getD(j);
                if (queryRDists[i] > range + rDist) continue;
                double dist = this.dm.dist(this.ownedVecs.get(i).get(j), query, qi, this.allVecs, this.distCache);
                if (!(d <= range)) continue;
                neighbors.add(this.ownedVecs.get(i).get(j));
                distances.add(dist);
            }
        }
        IndexTable it = new IndexTable(distances);
        it.apply(neighbors);
        it.apply(distances);
    }

    @Override
    public void search(Vec query, int numNeighbors, List<Integer> neighbors, List<Double> distances) {
        BoundedSortedList<IndexDistPair> knn = new BoundedSortedList<IndexDistPair>(numNeighbors);
        neighbors.clear();
        distances.clear();
        List<Double> qi = this.dm.getQueryInfo(query);
        if (this.repRadius == null) {
            for (int i = 0; i < this.allVecs.size(); ++i) {
                knn.add(new IndexDistPair(i, this.dm.dist(i, query, qi, this.allVecs, this.distCache)));
            }
        } else {
            double[] queryRDists = new double[this.R.size()];
            Arrays.fill(queryRDists, Double.MAX_VALUE);
            int bestRep = 0;
            for (int i = 0; i < this.R.size(); ++i) {
                double d;
                queryRDists[i] = this.dm.dist(this.R.get(i), query, qi, this.allVecs, this.distCache);
                if (!(d < queryRDists[bestRep])) continue;
                bestRep = i;
            }
            knn.add(new IndexDistPair(this.R.get(bestRep), queryRDists[bestRep]));
            IndexTable it = new IndexTable(queryRDists);
            int kth_best_rept = numNeighbors < this.R.size() ? it.index(numNeighbors - 1) : -1;
            for (int v : this.ownedVecs.get(bestRep)) {
                knn.add(new IndexDistPair(v, this.dm.dist(v, query, qi, this.allVecs, this.distCache)));
            }
            for (int sorted_order = 1; sorted_order < this.R.size(); ++sorted_order) {
                int i = it.index(sorted_order);
                if (knn.size() == numNeighbors && (queryRDists[i] > ((IndexDistPair)knn.last()).getDist() + this.repRadius[i] || kth_best_rept >= 0 && queryRDists[i] > 3.0 * queryRDists[kth_best_rept])) continue;
                knn.add(new IndexDistPair(this.R.get(i), queryRDists[i]));
                List<Integer> L_i_index = this.ownedVecs.get(i);
                DoubleList L_i_radius = this.ownedRDists.get(i);
                for (int j = 0; j < this.ownedVecs.get(i).size(); ++j) {
                    double rDist = L_i_radius.getD(j);
                    if (knn.size() == numNeighbors && queryRDists[i] > ((IndexDistPair)knn.last()).getDist() + rDist) continue;
                    int indx = L_i_index.get(j);
                    Vec v = (Vec)this.allVecs.get(indx);
                    knn.add(new IndexDistPair(indx, this.dm.dist(indx, query, qi, this.allVecs, this.distCache)));
                }
            }
        }
        for (IndexDistPair v : knn) {
            neighbors.add(v.getIndex());
            distances.add(v.getDist());
        }
    }

    @Override
    public void insert(V x) {
        int i;
        int new_indx = this.allVecs.size();
        this.allVecs.add(x);
        List<Double> qi = this.dm.getQueryInfo((Vec)x);
        if (this.distCache != null) {
            this.distCache.addAll(qi);
        }
        ++this.size;
        if (this.size < 10) {
            this.R.add(new_indx);
            return;
        }
        if (this.repRadius == null) {
            this.R.add(new_indx);
            this.setUp(new IntList(this.R), false);
            return;
        }
        double[] queryRDists = new double[this.R.size()];
        Arrays.fill(queryRDists, Double.MAX_VALUE);
        int bestRep = 0;
        for (int i2 = 0; i2 < this.R.size(); ++i2) {
            double d;
            queryRDists[i2] = this.dm.dist(this.R.get(i2), (Vec)x, qi, (List<? extends Vec>)this.allVecs, this.distCache);
            if (!(d < queryRDists[bestRep])) continue;
            bestRep = i2;
        }
        this.ownedVecs.get(bestRep).add(new_indx);
        this.ownedRDists.get(bestRep).add(queryRDists[bestRep]);
        this.repRadius[bestRep] = Math.max(this.repRadius[bestRep], queryRDists[bestRep]);
        if (Math.pow(Math.ceil(Math.sqrt(this.size)), 2.0) != (double)this.size) {
            return;
        }
        int new_r_vec_indx = -1;
        int R_pos = 0;
        for (int ran_val = new Random().nextInt(this.size - this.R.size() - 1); ran_val >= 0; ran_val -= this.ownedVecs.get(R_pos++).size()) {
            if (ran_val >= this.ownedVecs.get(R_pos).size()) {
                continue;
            }
            new_r_vec_indx = this.ownedVecs.get(R_pos).remove(ran_val);
            this.ownedRDists.get(R_pos).remove(ran_val);
            this.repRadius[R_pos] = 0.0;
            Object object = this.ownedRDists.get(R_pos).iterator();
            while (object.hasNext()) {
                double d = (Double)object.next();
                this.repRadius[R_pos] = Math.max(this.repRadius[R_pos], d);
            }
            break block1;
        }
        double max_radius = 0.0;
        for (double d : this.repRadius) {
            max_radius = Math.max(max_radius, d);
        }
        IntList potentialChildIndx = new IntList();
        DoubleList potentialChildDist = new DoubleList();
        this.search((Vec)this.get(new_r_vec_indx), max_radius, (List<Integer>)potentialChildIndx, (List<Double>)potentialChildDist);
        this.repRadius = Arrays.copyOf(this.repRadius, this.repRadius.length + 1);
        this.R.add(new_r_vec_indx);
        this.ownedRDists.add(new DoubleList());
        this.ownedVecs.add(new IntList());
        int r_new = this.R.size() - 1;
        int[] whoOwnsMe = new int[this.allVecs.size()];
        Arrays.fill(whoOwnsMe, -1);
        double[] distToMyOwner = new double[this.allVecs.size()];
        for (int i3 = 0; i3 < this.R.size() - 1; ++i3) {
            List<Integer> L_ry = this.ownedVecs.get(i3);
            for (int j = 0; j < L_ry.size(); ++j) {
                whoOwnsMe[L_ry.get((int)j).intValue()] = i3;
                distToMyOwner[L_ry.get((int)j).intValue()] = this.ownedRDists.get(i3).getD(j);
            }
        }
        boolean[] R_is_dirty = new boolean[this.R.size()];
        Arrays.fill(R_is_dirty, false);
        R_is_dirty[r_new] = true;
        for (i = 0; i < potentialChildIndx.size(); ++i) {
            double d_y_ry;
            double d_y_r_new = potentialChildDist.getD(i);
            int y_indx = potentialChildIndx.getI(i);
            int r_y = whoOwnsMe[y_indx];
            if (r_y == -1 || !((d_y_ry = distToMyOwner[y_indx]) > d_y_r_new)) continue;
            R_is_dirty[r_y] = true;
            whoOwnsMe[y_indx] = r_new;
            distToMyOwner[y_indx] = d_y_r_new;
        }
        for (int r_indx = 0; r_indx < this.R.size(); ++r_indx) {
            if (!R_is_dirty[r_indx]) continue;
            this.repRadius[r_indx] = 0.0;
            this.ownedRDists.get(r_indx).clear();
            this.ownedVecs.get(r_indx).clear();
        }
        for (i = 0; i < whoOwnsMe.length; ++i) {
            int r_i = whoOwnsMe[i];
            if (r_i == -1 || !R_is_dirty[r_i]) continue;
            this.repRadius[r_i] = Math.max(this.repRadius[r_i], distToMyOwner[i]);
            this.ownedRDists.get(r_i).add(distToMyOwner[i]);
            this.ownedVecs.get(r_i).add(i);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(int indx) {
        return (V)((Vec)this.allVecs.get(indx));
    }

    @Override
    public RandomBallCover<V> clone() {
        return new RandomBallCover<V>(this);
    }

    @Override
    public void setDistanceMetric(DistanceMetric dm) {
        this.dm = dm;
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        return this.dm;
    }
}

