/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import jsat.linear.LUPDecomposition;
import jsat.linear.Matrix;
import jsat.linear.Vec;

public class QRDecomposition
implements Serializable {
    private static final long serialVersionUID = 7578073062361216223L;
    private Matrix Q_T;
    private Matrix R;

    public QRDecomposition(Matrix Q, Matrix R) {
        if (!Q.isSquare()) {
            throw new ArithmeticException("Q is always square, rectangular Q is invalid");
        }
        if (Q.rows() != R.rows()) {
            throw new ArithmeticException("Q and R do not agree");
        }
        this.Q_T = Q;
        this.Q_T.mutableTranspose();
        this.R = R;
    }

    public QRDecomposition(Matrix A) {
        Matrix[] qr = A.clone().qr();
        this.Q_T = qr[0];
        this.Q_T.mutableTranspose();
        this.R = qr[1];
    }

    public QRDecomposition(Matrix A, ExecutorService threadpool) {
        Matrix[] qr = A.clone().qr(threadpool);
        this.Q_T = qr[0];
        this.Q_T.mutableTranspose();
        this.R = qr[1];
    }

    public double absDet() {
        if (!this.R.isSquare()) {
            throw new ArithmeticException("Can only compute the determinant of a square matrix");
        }
        double absD = 1.0;
        for (int i = 0; i < Math.min(this.R.rows(), this.R.cols()); ++i) {
            absD *= this.R.get(i, i);
        }
        return Math.abs(absD);
    }

    public Vec solve(Vec b) {
        if (b.length() != this.R.rows()) {
            throw new ArithmeticException("Matrix vector dimensions do not agree");
        }
        Vec y = this.Q_T.multiply(b);
        Vec x = LUPDecomposition.backSub(this.R, y);
        return x;
    }

    public Matrix solve(Matrix B) {
        Matrix y = this.Q_T.multiply(B);
        Matrix x = LUPDecomposition.backSub(this.R, y);
        return x;
    }

    public Matrix solve(Matrix B, ExecutorService threadpool) {
        Matrix y = this.Q_T.multiply(B, threadpool);
        Matrix x = LUPDecomposition.backSub(this.R, y, threadpool);
        return x;
    }
}

