/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.kernels;

import jsat.distributions.kernels.BaseKernelTrick;
import jsat.linear.Vec;

public class LinearKernel
extends BaseKernelTrick {
    private static final long serialVersionUID = -1870181048970135367L;
    private double c;

    public LinearKernel(double c) {
        this.c = c;
    }

    public LinearKernel() {
        this(1.0);
    }

    public void setC(double c) {
        if (c < 0.0 || Double.isInfinite(c) || Double.isNaN(c)) {
            throw new IllegalArgumentException("C must be a positive constant, not " + c);
        }
        this.c = c;
    }

    public double getC() {
        return this.c;
    }

    @Override
    public double eval(Vec a, Vec b) {
        return a.dot(b) + this.c;
    }

    @Override
    public String toString() {
        return "Linear Kernel (c=" + this.c + ")";
    }

    @Override
    public LinearKernel clone() {
        return new LinearKernel(this.c);
    }
}

