/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.discrete;

import jsat.distributions.discrete.DiscreteDistribution;

public class UniformDiscrete
extends DiscreteDistribution {
    private int min;
    private int max;

    public UniformDiscrete() {
        this(0, 10);
    }

    public UniformDiscrete(int min, int max) {
        this.setMinMax(min, max);
    }

    public void setMinMax(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("The input minimum (" + min + ") must be less than the given max (" + max + ")");
        }
        this.min = min;
        this.max = max;
    }

    public void setMin(int min) {
        if (min >= this.max) {
            throw new IllegalArgumentException(min + " must be less than the max value " + this.max);
        }
        this.min = min;
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int max) {
        if (max <= this.min) {
            throw new IllegalArgumentException(max + " must be greater than the min value " + this.min);
        }
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public double pmf(int x) {
        if (x < this.min || x > this.max) {
            return 0.0;
        }
        return 1.0 / (double)(1 + this.max - this.min);
    }

    @Override
    public double cdf(int x) {
        if (x >= this.max) {
            return 1.0;
        }
        if (x < this.min) {
            return 0.0;
        }
        return (double)(1 - this.min + x) / (double)(1 + this.max - this.min);
    }

    @Override
    public double invCdf(double p) {
        if (p <= 0.0) {
            return this.min;
        }
        if (p >= 1.0) {
            return this.max;
        }
        return Math.max(1.0, Math.ceil((double)(1 + this.max - this.min) * p) + (double)this.min - 1.0);
    }

    @Override
    public double mean() {
        return (double)this.max / 2.0 + (double)this.min / 2.0;
    }

    @Override
    public double median() {
        return Math.floor(this.mean());
    }

    @Override
    public double mode() {
        return Double.NaN;
    }

    @Override
    public double variance() {
        long dif = this.max - this.min + 1;
        dif *= dif;
        return (double)(dif - 1L) / 12.0;
    }

    @Override
    public double skewness() {
        return 0.0;
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }

    @Override
    public DiscreteDistribution clone() {
        return new UniformDiscrete(this.min, this.max);
    }
}

