/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.Distribution;
import jsat.linear.Vec;
import jsat.math.integration.Romberg;
import jsat.math.optimization.oned.GoldenSearch;
import jsat.math.rootfinding.Zeroin;

public abstract class ContinuousDistribution
extends Distribution {
    private static final long serialVersionUID = -5079392926462355615L;

    public double logPdf(double x) {
        double pdf = this.pdf(x);
        if (pdf <= 0.0) {
            return -1.7976931348623157E308;
        }
        return Math.log(pdf);
    }

    public abstract double pdf(double var1);

    @Override
    public double cdf(double x) {
        double intMin = this.getIntegrationMin();
        return Romberg.romb(z -> this.pdf(z), intMin, x);
    }

    @Override
    public double invCdf(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Value of p must be in the range [0,1], not " + p);
        }
        double a = this.getIntegrationMin();
        double b = this.getIntegrationMax();
        return Zeroin.root(a, b, x -> this.cdf(x) - p);
    }

    @Override
    public double mean() {
        double intMin = this.getIntegrationMin();
        double intMax = this.getIntegrationMax();
        return Romberg.romb(x -> x * this.pdf(x), intMin, intMax);
    }

    @Override
    public double variance() {
        double intMin = this.getIntegrationMin();
        double intMax = this.getIntegrationMax();
        double mean = this.mean();
        return Romberg.romb(x -> Math.pow(x - mean, 2.0) * this.pdf(x), intMin, intMax);
    }

    @Override
    public double skewness() {
        double intMin = this.getIntegrationMin();
        double intMax = this.getIntegrationMax();
        double mean = this.mean();
        return Romberg.romb(x -> Math.pow(x - mean, 3.0) * this.pdf(x), intMin, intMax) / Math.pow(this.variance(), 1.5);
    }

    @Override
    public double mode() {
        double intMin = this.getIntegrationMin();
        double intMax = this.getIntegrationMax();
        return GoldenSearch.findMin(intMin, intMax, x -> -this.pdf(x), 1.0E-6, 1000);
    }

    protected double getIntegrationMin() {
        double intMin = this.min();
        if (Double.isInfinite(intMin)) {
            double sqrt;
            intMin = -4.4942328371557893E307;
            for (int i = 0; i < 8 && this.pdf(sqrt = Math.sqrt(-intMin)) < 1.0E-5; ++i) {
                intMin = -sqrt;
            }
            while (this.pdf(intMin) < 1.0E-5 && intMin < -0.1) {
                intMin /= 2.0;
            }
            if (this.pdf(intMin) < 1.0E-5) {
                intMin *= -1.0;
            }
            while (this.pdf(intMin) < 1.0E-5) {
                intMin *= 2.0;
            }
        }
        return intMin;
    }

    protected double getIntegrationMax() {
        double intMax = this.max();
        if (Double.isInfinite(intMax)) {
            double sqrt;
            intMax = 4.4942328371557893E307;
            for (int i = 0; i < 8 && this.pdf(sqrt = Math.sqrt(intMax)) < 1.0E-5; ++i) {
                intMax = sqrt;
            }
            while (this.pdf(intMax) < 1.0E-5 && intMax > 0.1) {
                intMax /= 2.0;
            }
            if (this.pdf(intMax) < 1.0E-5) {
                intMax *= -1.0;
            }
            while (this.pdf(intMax) < 1.0E-5) {
                intMax *= 2.0;
            }
        }
        return intMax;
    }

    public String getDescriptiveName() {
        StringBuilder sb = new StringBuilder(this.getDistributionName());
        sb.append("(");
        String[] vars = this.getVariables();
        double[] vals = this.getCurrentVariableValues();
        sb.append(vars[0]).append(" = ").append(vals[0]);
        for (int i = 1; i < vars.length; ++i) {
            sb.append(", ").append(vars[i]).append(" = ").append(vals[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public abstract String getDistributionName();

    public abstract String[] getVariables();

    public abstract double[] getCurrentVariableValues();

    public abstract void setVariable(String var1, double var2);

    @Override
    public abstract ContinuousDistribution clone();

    public abstract void setUsingData(Vec var1);

    public String toString() {
        return this.getDistributionName();
    }
}

