/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.evaluation;

import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.evaluation.ClassificationScore;
import jsat.linear.DenseMatrix;
import jsat.linear.Matrix;

public class Kappa
implements ClassificationScore {
    private static final long serialVersionUID = -1684937057234736715L;
    private Matrix errorMatrix;

    public Kappa() {
    }

    public Kappa(Kappa toClone) {
        if (toClone.errorMatrix != null) {
            this.errorMatrix = toClone.errorMatrix.clone();
        }
    }

    @Override
    public void addResult(CategoricalResults prediction, int trueLabel, double weight) {
        this.errorMatrix.increment(prediction.mostLikely(), trueLabel, weight);
    }

    @Override
    public void addResults(ClassificationScore other) {
        Kappa otherObj = (Kappa)other;
        if (otherObj.errorMatrix == null) {
            return;
        }
        if (this.errorMatrix == null) {
            throw new RuntimeException("KappaScore has not been prepared");
        }
        this.errorMatrix.mutableAdd(otherObj.errorMatrix);
    }

    @Override
    public void prepare(CategoricalData toPredict) {
        int N = toPredict.getNumOfCategories();
        this.errorMatrix = new DenseMatrix(N, N);
    }

    @Override
    public double getScore() {
        double[] rowTotals = new double[this.errorMatrix.rows()];
        double[] colTotals = new double[this.errorMatrix.rows()];
        for (int i = 0; i < this.errorMatrix.rows(); ++i) {
            rowTotals[i] = this.errorMatrix.getRowView(i).sum();
            colTotals[i] = this.errorMatrix.getColumnView(i).sum();
        }
        double chanceAgreement = 0.0;
        double accuracy = 0.0;
        double totalCount = 0.0;
        for (int i = 0; i < rowTotals.length; ++i) {
            chanceAgreement += rowTotals[i] * colTotals[i];
            totalCount += rowTotals[i];
            accuracy += this.errorMatrix.get(i, i);
        }
        return ((accuracy /= totalCount) - (chanceAgreement /= totalCount * totalCount)) / (1.0 - chanceAgreement);
    }

    @Override
    public boolean equals(Object obj) {
        return this.getClass().isAssignableFrom(obj.getClass()) && obj.getClass().isAssignableFrom(this.getClass());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean lowerIsBetter() {
        return false;
    }

    @Override
    public Kappa clone() {
        return new Kappa(this);
    }

    @Override
    public String getName() {
        return "Kappa";
    }
}

