/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.parameterdatabase;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.freehep.swing.CellOrientatedTable;
import org.freehep.util.parameterdatabase.ClassIterator;
import org.freehep.util.parameterdatabase.DatabaseListener;
import org.freehep.util.parameterdatabase.ParameterDatabase;
import org.freehep.util.parameterdatabase.editor.DoubleRangeEditor;
import org.freehep.util.parameterdatabase.editor.SelectorEditor;
import org.freehep.util.parameterdatabase.selector.Selector;
import org.freehep.util.parameterdatabase.types.DoubleRange;

public class DatabaseTable
implements TableModel,
DatabaseListener {
    private JComponent table;
    private Object key = null;
    private boolean local;
    private ClassIterator classIterator = null;
    private String[] names = null;
    ParameterDatabase database;
    protected LinkedList tableModelListeners = new LinkedList();

    public DatabaseTable(ParameterDatabase database) {
        this(database, true);
    }

    public DatabaseTable(ParameterDatabase database, boolean local) {
        if (database == null) {
            throw new IllegalArgumentException();
        }
        this.local = local;
        this.database = database;
        this.table = this.makeForm();
    }

    public JComponent getForm() {
        return this.table;
    }

    public void setKeyObject(Object key) {
        if (this.key != key) {
            this.key = key;
            if (key != null) {
                this.classIterator = new ClassIterator(key);
                this.names = this.database.getCurrentParameterSet(this.classIterator);
            } else {
                this.classIterator = null;
                this.names = null;
            }
            this.fireTableChanged();
        }
    }

    @Override
    public void databaseUpdated() {
        this.fireTableChanged();
    }

    public void fireTableChanged() {
        TableModelEvent event = new TableModelEvent(this);
        for (TableModelListener listener : this.tableModelListeners) {
            listener.tableChanged(event);
        }
    }

    private JComponent makeForm() {
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        CellOrientatedTable table = new CellOrientatedTable(this);
        table.setDefaultEditor(Selector.class, new SelectorEditor());
        table.setDefaultEditor(DoubleRange.class, new DoubleRangeEditor());
        JScrollPane scroll = new JScrollPane(table);
        main.add((Component)scroll, "Center");
        return main;
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        if (listener != null) {
            this.tableModelListeners.add(listener);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.tableModelListeners.remove(listener);
    }

    public Class getColumnClass(int columnIndex) {
        Class columnClass;
        if (!this.local) {
            ++columnIndex;
        }
        switch (columnIndex) {
            case 0: {
                columnClass = Boolean.class;
                break;
            }
            case 1: {
                columnClass = String.class;
                break;
            }
            case 2: {
                columnClass = Object.class;
                break;
            }
            default: {
                columnClass = null;
            }
        }
        return columnClass;
    }

    @Override
    public int getColumnCount() {
        return this.local ? 3 : 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String columnName;
        if (!this.local) {
            ++columnIndex;
        }
        switch (columnIndex) {
            case 0: {
                columnName = "Local";
                break;
            }
            case 1: {
                columnName = "Parameter";
                break;
            }
            case 2: {
                columnName = "Value";
                break;
            }
            default: {
                columnName = null;
            }
        }
        return columnName;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.local) {
            return columnIndex == 0 || columnIndex == 2;
        }
        return columnIndex == 1;
    }

    @Override
    public int getRowCount() {
        return this.names != null ? this.names.length : 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.local) {
            ++columnIndex;
        }
        if (columnIndex == 0) {
            this.classIterator.reset();
            String name = this.names[rowIndex];
            if (this.database.isParameterLocal(name, this.classIterator)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (columnIndex == 1) {
            return this.names[rowIndex];
        }
        if (columnIndex == 2) {
            this.classIterator.reset();
            String name = this.names[rowIndex];
            return this.database.getParameter(name, this.classIterator);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int cIndex = columnIndex;
        if (!this.local) {
            ++cIndex;
        }
        if (cIndex == 0 && aValue instanceof Boolean) {
            String name;
            boolean makeLocal = (Boolean)aValue;
            if (makeLocal) {
                name = this.names[rowIndex];
                Object value = this.getValueAt(rowIndex, 2);
                if (value != null) {
                    Object firstObject = null;
                    this.classIterator.reset();
                    if (this.classIterator.hasNext()) {
                        firstObject = this.classIterator.next();
                    }
                    PropertyChangeListener listener = null;
                    if (firstObject instanceof PropertyChangeListener) {
                        listener = (PropertyChangeListener)firstObject;
                    }
                    this.classIterator.reset();
                    this.database.addParameter(name, value, this.classIterator, listener);
                }
            } else {
                name = this.names[rowIndex];
                this.classIterator.reset();
                this.database.removeParameter(name, this.classIterator);
            }
        }
        if (cIndex == 2) {
            String name = this.names[rowIndex];
            Object object = this.getValueAt(rowIndex, columnIndex);
            Class<?> c = object.getClass();
            if (c.equals(aValue.getClass())) {
                this.classIterator.reset();
                this.database.setParameter(name, aValue, this.classIterator);
            } else if (aValue instanceof String) {
                String value = (String)aValue;
                if (object != null) {
                    Object[] parameters = new Object[]{value};
                    Class[] parameterTypes = new Class[]{String.class};
                    try {
                        Class<?> objectClass = object.getClass();
                        Constructor<?> constructor = objectClass.getConstructor(parameterTypes);
                        Object newValue = constructor.newInstance(parameters);
                        this.classIterator.reset();
                        this.database.setParameter(name, newValue, this.classIterator);
                    }
                    catch (NoSuchMethodException nsme) {
                        nsme.printStackTrace();
                    }
                    catch (InstantiationException ie) {
                        ie.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

