/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.rtti;

import java.util.Properties;
import java.util.Vector;
import org.freehep.rtti.INamedType;
import org.freehep.rtti.RTTI;

public class IConstructor {
    private String name;
    private Vector comments;
    private INamedType[] parameterTypes;
    private String[] exceptionTypes;

    IConstructor(String name, Vector comments, INamedType[] parameterTypes, String[] exceptionTypes) {
        this.name = name;
        this.comments = comments;
        this.parameterTypes = parameterTypes;
        this.exceptionTypes = exceptionTypes;
    }

    public String getName() {
        return this.name;
    }

    public String[] getComments(String language) {
        return RTTI.getComments(this.comments, language);
    }

    public INamedType[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public String getSignature(String packageName, Properties imports) {
        StringBuffer s = new StringBuffer();
        s.append("(");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            s.append(this.parameterTypes[i].getSignature(packageName, imports));
        }
        s.append(")V");
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("");
        String[] comments = this.getComments(null);
        for (int i = 0; i < comments.length; ++i) {
            s.append(comments[i]);
            s.append("\n");
        }
        s.append(this.getSignature("", new Properties()));
        s.append("\n");
        s.append("    public ");
        s.append(this.getName());
        s.append(" (");
        INamedType[] parameterTypes = this.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            s.append(parameterTypes[i]);
            if (i >= parameterTypes.length - 1) continue;
            s.append(", ");
        }
        s.append(" )");
        String[] exceptionTypes = this.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            s.append(" throws ");
            for (int i = 0; i < exceptionTypes.length; ++i) {
                s.append(exceptionTypes[i]);
                if (i >= exceptionTypes.length - 1) continue;
                s.append(", ");
            }
        }
        s.append(";");
        return s.toString();
    }
}

