/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.MatrixOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;

class Translate
extends MatrixOperator {
    Translate() {
        this.operandTypes = new Class[]{PSObject.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSNumber.class, PSNumber.class)) {
            double ty = os.popNumber().getDouble();
            double tx = os.popNumber().getDouble();
            os.gstate().translate(tx, ty);
        } else if (os.checkType(PSNumber.class, PSNumber.class, PSArray.class)) {
            PSArray a = os.popArray();
            if (a.size() >= 6) {
                PSNumber ty = os.popNumber();
                PSNumber tx = os.popNumber();
                a.set(0, 1);
                a.set(1, 0);
                a.set(2, 0);
                a.set(3, 1);
                a.set(4, tx);
                a.set(5, ty);
                os.push(a);
            } else {
                Translate.error(os, new RangeCheck());
            }
        } else {
            Translate.error(os, new TypeCheck());
        }
        return true;
    }
}

