/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.File;
import org.freehep.postscript.FileOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSFile;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSString;
import org.freehep.postscript.TypeCheck;

class Status
extends FileOperator {
    Status() {
        this.operandTypes = new Class[]{PSObject.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSFile.class)) {
            PSFile file = os.popFile();
            os.push(file.isValid());
        } else if (os.checkType(PSString.class)) {
            PSString name = os.popString();
            File file = new File(name.getValue());
            if (file.exists() && file.isFile()) {
                os.push(file.length() / 1024L);
                os.push(file.length());
                os.push(file.lastModified());
                os.push(file.lastModified());
                os.push(true);
            } else {
                os.push(false);
            }
        } else {
            Status.error(os, new TypeCheck());
        }
        return true;
    }
}

