/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.GraphicsStateOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPaint;
import org.freehep.postscript.TypeCheck;
import org.freehep.postscript.Undefined;

class SetColor
extends GraphicsStateOperator {
    SetColor() {
        this.operandTypes = new Class[]{PSObject.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSNumber.class)) {
            String space = os.gstate().colorSpace();
            if (space.equals("DeviceGray")) {
                PSNumber g = os.popNumber();
                os.gstate().setColor(new float[]{g.getFloat()});
            } else if (space.equals("DeviceRGB")) {
                PSNumber blue = os.popNumber();
                PSNumber green = os.popNumber();
                PSNumber red = os.popNumber();
                os.gstate().setColor(new float[]{red.getFloat(), green.getFloat(), blue.getFloat()});
            } else if (space.equals("DeviceCMYK")) {
                PSNumber black = os.popNumber();
                PSNumber yellow = os.popNumber();
                PSNumber magenta = os.popNumber();
                PSNumber cyan = os.popNumber();
                os.gstate().setColor(new float[]{cyan.getFloat(), magenta.getFloat(), yellow.getFloat(), black.getFloat()});
            } else {
                SetColor.error(os, new Undefined());
            }
        } else if (os.checkType(PSDictionary.class)) {
            PSDictionary pattern = os.popDictionary();
            PSPaint paint = (PSPaint)pattern.get("Implementation");
            int patternType = pattern.getInteger("PatternType");
            int paintType = pattern.getInteger("PaintType");
            if (patternType == 1 && paintType == 2) {
                os.gstate().setColor(paint.getValue(), new PSObject[0]);
            } else {
                os.gstate().setColor(paint.getValue());
            }
        } else {
            SetColor.error(os, new TypeCheck());
        }
        return true;
    }
}

