/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import org.freehep.postscript.ByteBuffer;
import org.freehep.postscript.DSC;
import org.freehep.postscript.NameLookup;
import org.freehep.postscript.NameNotFoundException;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSComment;
import org.freehep.postscript.PSDSC;
import org.freehep.postscript.PSMark;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.PSUtils;
import org.freehep.postscript.PostScriptStack;
import org.freehep.postscript.SyntaxException;
import org.freehep.util.io.ASCII85InputStream;
import org.freehep.util.io.ASCIIHexInputStream;
import org.freehep.util.io.EncodingException;

public class Scanner {
    private PushbackInputStream in;
    private ByteBuffer buffer;
    private int lineNo;
    private int openCurly;
    private int openSquare;
    private PostScriptStack procStack;
    private boolean nextIsComment;
    private boolean nextIsDSC;
    private DSC dsc;

    public Scanner(PushbackInputStream in, DSC dsc) throws IOException {
        this.in = in;
        this.buffer = new ByteBuffer(80);
        this.lineNo = 1;
        this.openCurly = 0;
        this.openSquare = 0;
        this.procStack = new PostScriptStack();
        this.nextIsComment = false;
        this.nextIsDSC = false;
        this.dsc = dsc;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public PSObject nextToken(boolean packingMode, NameLookup lookup) throws IOException, SyntaxException, NameNotFoundException {
        PSObject obj = this.nextObject(packingMode, lookup);
        while (this.openCurly > 0 && !(obj instanceof PSComment) && !(obj instanceof PSDSC)) {
            this.procStack.push(obj);
            obj = this.nextObject(packingMode, lookup);
        }
        return obj;
    }

    private PSObject nextObject(boolean packingMode, NameLookup lookup) throws IOException, SyntaxException, NameNotFoundException {
        this.buffer.reset();
        if (this.nextIsComment) {
            return this.readComment();
        }
        if (this.nextIsDSC) {
            return this.readDSC();
        }
        int next = this.readNext();
        switch (next) {
            case -1: {
                return null;
            }
            case 40: {
                return this.readString();
            }
            case 41: {
                throw new SyntaxException(this.lineNo, "Unbalanced Parenthesis");
            }
            case 126: {
                next = this.in.read();
                if (next == 62) {
                    throw new SyntaxException(this.lineNo, "Non matching '~>'");
                }
                if (next > 0) {
                    this.in.unread(next);
                }
                return this.readName(126, false);
            }
            case 62: {
                next = this.in.read();
                if (next == 62) {
                    return new PSName(">>");
                }
                if (next > 0) {
                    this.in.unread(next);
                }
                throw new SyntaxException(this.lineNo, "Non matching '>'");
            }
            case 60: {
                return this.readEncoding();
            }
            case 91: {
                ++this.openSquare;
                return new PSName("[");
            }
            case 93: {
                if (this.openSquare > 0) {
                    --this.openSquare;
                    return new PSName("]");
                }
                throw new SyntaxException(this.lineNo, "Non matching ']'");
            }
            case 123: {
                ++this.openCurly;
                return new PSMark();
            }
            case 125: {
                int n;
                if (this.openCurly > 0) {
                    --this.openCurly;
                }
                if ((n = this.procStack.countToMark()) < 0) {
                    throw new SyntaxException(this.lineNo, "Unmatched '{'");
                }
                PSObject[] array = new PSObject[n];
                for (int i = n - 1; i >= 0; --i) {
                    array[i] = this.procStack.popObject();
                }
                this.procStack.popMark();
                PSPackedArray proc = packingMode ? new PSPackedArray(array) : new PSArray(array);
                proc.setExecutable();
                return proc;
            }
            case 47: {
                return this.readLiteral(lookup);
            }
            case 37: {
                next = this.in.read();
                if ((next == 37 || next == 33) && this.dsc != null) {
                    return this.readDSC();
                }
                if (next > 0) {
                    this.in.unread(next);
                }
                return this.readComment();
            }
            case 64: {
                return this.readComment();
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.readNumber(next);
            }
        }
        return this.readName(next, false);
    }

    public int getLineNo() {
        return this.lineNo;
    }

    private PSString readString() throws IOException {
        int balance = 1;
        int next = this.in.read();
        while (balance > 0 && next != -1) {
            switch (next) {
                case 92: {
                    this.escapeChar();
                    break;
                }
                case 40: {
                    ++balance;
                    this.buffer.append(next);
                    break;
                }
                case 41: {
                    if (--balance <= 0) break;
                    this.buffer.append(next);
                    break;
                }
                case 13: {
                    next = this.in.read();
                    if (next != 10 && next > 0) {
                        this.in.unread(next);
                    }
                    this.buffer.append('\n');
                    ++this.lineNo;
                    break;
                }
                case 10: {
                    this.buffer.append(next);
                    ++this.lineNo;
                    break;
                }
                default: {
                    this.buffer.append(next);
                }
            }
            next = this.in.read();
        }
        if (balance == 0 && next > 0) {
            this.in.unread(next);
        }
        return new PSString(this.buffer.getChars());
    }

    private void escapeChar() throws IOException {
        int next = this.in.read();
        if (next == -1) {
            throw new EOFException("Unexpected End Of File");
        }
        switch (next) {
            case 110: {
                this.buffer.append('\n');
                break;
            }
            case 114: {
                this.buffer.append('\r');
                break;
            }
            case 116: {
                this.buffer.append('\t');
                break;
            }
            case 98: {
                this.buffer.append('\b');
                break;
            }
            case 102: {
                this.buffer.append('\f');
                break;
            }
            case 92: {
                this.buffer.append('\\');
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                StringBuffer octal = new StringBuffer(3);
                octal.append(next - 48);
                next = this.in.read();
                if (next == -1) {
                    throw new EOFException("Unexpected End Of File");
                }
                if (48 <= next && next <= 55) {
                    octal.append(next - 48);
                    next = this.in.read();
                    if (next == -1) {
                        throw new EOFException("Unexpected End Of File");
                    }
                    if (48 <= next && next <= 55) {
                        octal.append(next - 48);
                    } else if (next > 0) {
                        this.in.unread(next);
                    }
                } else if (next > 0) {
                    this.in.unread(next);
                }
                this.buffer.append(Integer.parseInt(octal.toString(), 8));
                return;
            }
            case 10: {
                next = this.in.read();
                ++this.lineNo;
                return;
            }
            case 13: {
                next = this.in.read();
                if (next == 10) {
                    next = this.in.read();
                }
                ++this.lineNo;
                return;
            }
            default: {
                this.buffer.append(next);
            }
        }
    }

    private PSComment readComment() throws IOException {
        this.nextIsComment = false;
        int next = this.in.read();
        while (next != -1 && next != 13 && next != 10) {
            this.buffer.append(next);
            next = this.in.read();
        }
        return new PSComment(this.buffer.getString());
    }

    private PSDSC readDSC() throws IOException {
        block6: {
            int next;
            this.nextIsDSC = false;
            do {
                next = this.in.read();
                while (next != -1 && next != 13 && next != 10) {
                    this.buffer.append(next);
                    next = this.in.read();
                }
                next = this.in.read();
                if (next == 13) {
                    next = this.in.read();
                }
                if (next != 37) {
                    if (next <= 0) break block6;
                    this.in.unread(next);
                    break block6;
                }
                next = this.in.read();
                if (next == 37) continue;
                if (next > 0) {
                    this.in.unread(next);
                }
                this.nextIsComment = true;
                break block6;
            } while ((next = this.in.read()) == 43);
            if (next > 0) {
                this.in.unread(next);
            }
            this.nextIsDSC = true;
        }
        return new PSDSC(this.buffer.getString(), this.dsc);
    }

    private PSObject readLiteral(NameLookup lookup) throws IOException, SyntaxException, NameNotFoundException {
        int next = this.in.read();
        if (next == -1) {
            throw new IOException("Unexpected EOF reached");
        }
        if (next == 47) {
            next = this.in.read();
            PSName name = this.readName(next, true);
            PSObject obj = lookup.lookup(name);
            if (obj == null) {
                throw new NameNotFoundException("Immediate name /'" + name + " not found.");
            }
            return obj;
        }
        return this.readName(next, true);
    }

    private PSName readName(int next, boolean literal) throws IOException, SyntaxException {
        boolean found = false;
        block5: while (!found) {
            switch (next) {
                case -1: 
                case 0: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    found = true;
                    continue block5;
                }
                case 41: {
                    throw new SyntaxException(this.lineNo, "Unbalanced Parenthesis");
                }
                case 37: 
                case 40: 
                case 47: 
                case 60: 
                case 62: 
                case 91: 
                case 93: 
                case 123: 
                case 125: {
                    found = true;
                    this.in.unread(next);
                    continue block5;
                }
            }
            this.buffer.append(next);
            next = this.in.read();
        }
        PSName name = new PSName(this.buffer.getString(), literal);
        return name;
    }

    private PSObject readNumber(int next) throws IOException, SyntaxException {
        String name = this.readName(next, false).getValue();
        try {
            return PSUtils.parseNumber(name);
        }
        catch (NumberFormatException numberFormatException) {
            return new PSName(name);
        }
    }

    private PSObject readEncoding() throws IOException, SyntaxException {
        int next = this.in.read();
        switch (next) {
            case 126: {
                ASCII85InputStream in85 = new ASCII85InputStream(this.in);
                try {
                    next = in85.read();
                    while (next != -1) {
                        this.buffer.append(next);
                        next = in85.read();
                    }
                }
                catch (EncodingException e) {
                    throw new SyntaxException(this.lineNo, e.getMessage());
                }
                this.lineNo += in85.getLineNo() - 1;
                return new PSString(this.buffer.getChars());
            }
            case 60: {
                return new PSName("<<");
            }
        }
        if (next > 0) {
            this.in.unread(next);
        }
        ASCIIHexInputStream inHex = new ASCIIHexInputStream(this.in);
        try {
            next = inHex.read();
            while (next != -1) {
                this.buffer.append(next);
                next = inHex.read();
            }
        }
        catch (EncodingException e) {
            throw new SyntaxException(this.lineNo, e.getMessage());
        }
        this.lineNo += inHex.getLineNo() - 1;
        return new PSString(this.buffer.getChars());
    }

    private int readNext() throws IOException {
        boolean ws;
        int next;
        do {
            next = this.in.read();
            switch (next) {
                case 13: {
                    next = this.in.read();
                    if (next != 10 && next > 0) {
                        this.in.unread(next);
                    }
                }
                case 10: {
                    ++this.lineNo;
                    ws = true;
                    break;
                }
                case 0: 
                case 8: 
                case 9: 
                case 12: 
                case 32: {
                    ws = true;
                    break;
                }
                default: {
                    ws = false;
                }
            }
        } while (next != -1 && ws);
        return ws ? -1 : next;
    }

    public static void main(String[] args) throws Exception {
        PSObject token;
        if (args.length != 1) {
            System.err.println("Usage: Scanner filename.ps");
            System.exit(1);
        }
        DSC dsc = new DSC();
        Scanner scanner = new Scanner(new PushbackInputStream(new FileInputStream(args[0])), dsc);
        while ((token = scanner.nextToken(true, null)) != null) {
            System.out.println(scanner.getLineNo() + ": " + token.getClass().getName() + ": " + token);
        }
        scanner.close();
    }
}

