/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.MatrixOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;

class Scale
extends MatrixOperator {
    Scale() {
        this.operandTypes = new Class[]{PSObject.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSNumber.class, PSNumber.class)) {
            double sy = os.popNumber().getDouble();
            double sx = os.popNumber().getDouble();
            os.gstate().scale(sx, sy);
        } else if (os.checkType(PSNumber.class, PSNumber.class, PSArray.class)) {
            PSArray a = os.popArray();
            if (a.size() >= 6) {
                PSNumber sy = os.popNumber();
                PSNumber sx = os.popNumber();
                a.set(0, sx);
                a.set(1, 0);
                a.set(2, 0);
                a.set(3, sy);
                a.set(4, 0);
                a.set(5, 0);
                os.push(a);
            } else {
                Scale.error(os, new RangeCheck());
            }
        } else {
            Scale.error(os, new TypeCheck());
        }
        return true;
    }
}

