/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.IOException;
import org.freehep.postscript.FileOperator;
import org.freehep.postscript.IOError;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSFile;
import org.freehep.postscript.PSString;
import org.freehep.postscript.RangeCheck;

class ReadLine
extends FileOperator {
    ReadLine() {
        this.operandTypes = new Class[]{PSFile.class, PSString.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        PSString string = os.popString();
        PSFile file = os.popFile();
        try {
            String line = file.readLine();
            if (line == null) {
                os.push(string.subString(0, 0));
                os.push(false);
                return true;
            }
            if (string.size() < line.length()) {
                ReadLine.error(os, new RangeCheck());
            } else {
                for (int i = 0; i < line.length(); ++i) {
                    string.set(i, line.charAt(i));
                }
                os.push(string.subString(0, line.length()));
                os.push(true);
            }
        }
        catch (IOException e) {
            ReadLine.error(os, new IOError());
        }
        return true;
    }
}

