/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.freehep.postscript.PSDevice;

public class PanelDevice
extends PSDevice {
    private final JPanel panel;
    private Graphics2D imageGraphics = null;

    public PanelDevice(JPanel panel) {
        this.panel = panel;
        panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                PanelDevice.this.fireComponentResizedEvent(event);
            }
        });
    }

    @Override
    public double getWidth() {
        return this.panel.getWidth();
    }

    @Override
    public double getHeight() {
        return this.panel.getHeight();
    }

    @Override
    public AffineTransform getDeviceTransform() {
        return this.panel.getGraphicsConfiguration().getDefaultTransform();
    }

    @Override
    public Graphics getDeviceGraphics() {
        return this.panel.getGraphics();
    }

    @Override
    public Graphics2D getGraphics() {
        if (this.imageGraphics != null) {
            return this.imageGraphics;
        }
        return super.getGraphics();
    }

    @Override
    public void refresh() {
        this.panel.repaint();
    }

    @Override
    public BufferedImage convertToImage(int width, int height) {
        BufferedImage image = (BufferedImage)this.panel.createImage(width, height);
        this.imageGraphics = (Graphics2D)image.getGraphics();
        return image;
    }
}

