/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.freehep.postscript.PSFile;
import org.freehep.postscript.PSObject;

public class PSRandomAccessFile
extends PSFile {
    protected RandomAccessFile raf = null;
    protected boolean write;
    protected boolean append;

    protected PSRandomAccessFile(String n, boolean f, RandomAccessFile r) {
        super(n, f);
        this.raf = r;
    }

    public PSRandomAccessFile(String filename, boolean write, boolean append, boolean secure) throws FileNotFoundException, IOException {
        super(filename, false);
        if (!secure) {
            throw new IOException();
        }
        this.write = write;
        this.append = append;
        File file = new File(filename);
        if (!write && !file.exists()) {
            throw new IOException();
        }
        this.raf = new RandomAccessFile(file, "rw");
        if (append) {
            this.raf.seek(this.raf.length());
        }
        if (write) {
            this.raf.seek(0L);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
    }

    @Override
    public int read() throws IOException {
        return this.raf != null ? this.raf.read() : -1;
    }

    @Override
    public String readLine() throws IOException {
        return this.raf != null ? this.raf.readLine() : null;
    }

    @Override
    public void write(int b, boolean secure) throws IOException {
        if (!secure) {
            throw new IOException();
        }
        if (this.raf == null) {
            throw new IOException();
        }
        this.raf.write(b);
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.raf == null) {
            throw new IOException();
        }
        this.raf.seek(pos);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.raf != null ? this.raf.getFilePointer() : -1L;
    }

    @Override
    public int available() throws IOException {
        return this.raf != null ? (int)(this.raf.length() - this.raf.getFilePointer()) : -1;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void reset() throws IOException {
        if (this.raf == null) {
            throw new IOException();
        }
        this.raf.seek(0L);
    }

    @Override
    public boolean isValid() {
        return this.raf != null;
    }

    @Override
    public int hashCode() {
        return this.raf.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PSRandomAccessFile) {
            return this.raf == ((PSRandomAccessFile)o).raf;
        }
        return false;
    }

    @Override
    public Object clone() {
        return new PSRandomAccessFile(this.filename, this.filter, this.raf);
    }

    @Override
    public PSObject copy() {
        if (this.filter) {
            throw new RuntimeException("Filters cannot be copied");
        }
        try {
            return new PSRandomAccessFile(this.filename, this.write, this.append, true);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot find file while copying: " + this.filename);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException for file while copying: " + this.filename);
        }
    }
}

