/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.DictionaryStack;
import org.freehep.postscript.ErrorOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PostScriptError;

public abstract class PSObject
implements Cloneable {
    private boolean literal;
    protected String name;

    public PSObject(String name, boolean literal) {
        this.name = name;
        this.literal = literal;
    }

    public void setName(String s) {
        this.name = s;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract Object clone();

    public abstract PSObject copy();

    public abstract String getType();

    public abstract boolean execute(OperandStack var1);

    public boolean checkAndExecute(OperandStack os) {
        return this.execute(os);
    }

    public static void error(OperandStack os, ErrorOperator error) {
        os.reset();
        DictionaryStack ds = os.dictStack();
        ErrorOperator e = (ErrorOperator)ds.errorDictionary().get(error.getName());
        os.execStack().push(e);
        throw new PostScriptError();
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public void setLiteral() {
        this.literal = true;
    }

    public void setExecutable() {
        this.literal = false;
    }

    public boolean isExecutable() {
        return !this.literal;
    }

    public abstract String cvs();

    public String toString() {
        return "--nostringval--";
    }

    public String toPrint() {
        return this.toString();
    }
}

