/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.util.Enumeration;
import java.util.Hashtable;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSBoolean;
import org.freehep.postscript.PSComposite;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSReal;
import org.freehep.postscript.PSString;

public class PSDictionary
extends PSComposite {
    protected Hashtable table;

    protected PSDictionary(Hashtable t) {
        super("dictionary", true);
        this.table = t;
    }

    public PSDictionary(int n) {
        this(new Hashtable(n));
    }

    public PSDictionary() {
        this(new Hashtable());
    }

    @Override
    public boolean execute(OperandStack os) {
        os.push(this);
        return true;
    }

    @Override
    public String getType() {
        return "dicttype";
    }

    public int capacity() {
        return this.table.size();
    }

    public int size() {
        return this.table.size();
    }

    public void put(PSObject key, PSObject value) {
        this.table.put(key, value);
    }

    public void put(String key, PSObject value) {
        this.table.put(new PSName(key), value);
    }

    public void put(String key, String value) {
        this.table.put(new PSName(key), new PSString(value));
    }

    public void put(String key, int value) {
        this.table.put(new PSName(key), new PSInteger(value));
    }

    public void put(String key, double value) {
        this.table.put(new PSName(key), new PSReal(value));
    }

    public void put(String key, boolean value) {
        this.table.put(new PSName(key), new PSBoolean(value));
    }

    public void put(PSName key, String[] value) {
        PSArray array = new PSArray(value);
        array.setLiteral();
        this.put((PSObject)key, (PSObject)array);
    }

    public Object[] keys() {
        return this.table.keySet().toArray();
    }

    public PSObject get(PSObject key) {
        return (PSObject)this.table.get(key);
    }

    public PSObject get(String key) {
        return (PSObject)this.table.get(new PSName(key));
    }

    public String getString(String key) {
        return ((PSString)this.table.get(new PSName(key))).getValue();
    }

    public PSNumber getNumber(String key) {
        return (PSNumber)this.table.get(new PSName(key));
    }

    public int getInteger(String key) {
        return ((PSInteger)this.table.get(new PSName(key))).getValue();
    }

    public double getReal(String key) {
        return ((PSReal)this.table.get(new PSName(key))).getValue();
    }

    public boolean getBoolean(String key) {
        return ((PSBoolean)this.table.get(new PSName(key))).getValue();
    }

    public PSPackedArray getPackedArray(String key) {
        return (PSPackedArray)this.table.get(new PSName(key));
    }

    public PSDictionary getDictionary(String key) {
        return (PSDictionary)this.table.get(new PSName(key));
    }

    public PSObject remove(PSObject key) {
        return (PSObject)this.table.remove(key);
    }

    public PSObject remove(String key) {
        return (PSObject)this.table.remove(new PSName(key));
    }

    public void copyInto(PSDictionary d) {
        Enumeration e = this.table.keys();
        while (e.hasMoreElements()) {
            PSObject key = (PSObject)e.nextElement();
            PSObject value = (PSObject)this.table.get(key);
            d.put(key, value);
        }
    }

    public void forAll(PSArray proc, OperandStack os) {
        Enumeration e = this.table.keys();
        while (e.hasMoreElements()) {
            PSObject key = (PSObject)e.nextElement();
            os.push(key);
            os.push((PSObject)this.table.get(key));
            proc.execute(os);
        }
    }

    @Override
    public int hashCode() {
        return this.table.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PSDictionary) {
            return this.table == ((PSDictionary)o).table;
        }
        return false;
    }

    @Override
    public Object clone() {
        return new PSDictionary(this.table);
    }

    @Override
    public PSObject copy() {
        Hashtable newTable = new Hashtable();
        for (Object key : this.table.keySet()) {
            newTable.put(key, this.table.get(key));
        }
        return new PSDictionary(newTable);
    }

    @Override
    public String cvs() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "--" + (this.isExecutable() ? "*" : "") + "dictionary (" + this.size() + ")--";
    }

    public String dumpKeys() {
        StringBuffer out = new StringBuffer();
        Enumeration e = this.table.keys();
        while (e.hasMoreElements()) {
            out.append(e.nextElement().toString());
            out.append(";");
        }
        return out.toString();
    }
}

