/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSReal;

public class PSArray
extends PSPackedArray {
    private PSArray(String n, PSObject[] a, int index, int count) {
        super(n, a, index, count);
        this.access = 3;
    }

    public PSArray(int n) {
        super(n);
        this.access = 3;
        this.setName("array");
    }

    public PSArray(PSObject[] a) {
        super(a);
        this.access = 3;
        this.setName("array");
    }

    public PSArray(float[] f) {
        super(f);
    }

    public PSArray(double[] d) {
        super(d);
    }

    public PSArray(String[] s) {
        super(s);
    }

    @Override
    public String getType() {
        return "arraytype";
    }

    public void set(int i, PSObject o) {
        this.array[this.start + i] = o;
    }

    public void set(int i, String s) {
        this.set(i, new PSName(s));
    }

    public void set(int i, double d) {
        this.set(i, new PSReal(d));
    }

    public void set(int i, int d) {
        this.set(i, new PSInteger(d));
    }

    public void set(double[] d) {
        for (int i = 0; i < d.length; ++i) {
            this.set(i, d[i]);
        }
    }

    public PSArray subArray(int index, int count) {
        if (index < 0 || index + count > this.length) {
            throw new IllegalArgumentException("Trying to create subArray(" + index + ", " + count + ") with length=" + this.length + ".");
        }
        return new PSArray(this.name, this.array, index, count);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PSArray) {
            return this.array == ((PSArray)o).array;
        }
        return false;
    }

    @Override
    public Object clone() {
        return new PSArray(this.name, this.array, this.start, this.length);
    }

    @Override
    public String cvs() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "--" + (this.isExecutable() ? "*" : "") + this.name + " (" + this.start + ".." + (this.start + this.length) + ") --";
    }
}

