/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.freehep.postscript.AShow;
import org.freehep.postscript.AWidthShow;
import org.freehep.postscript.CShow;
import org.freehep.postscript.ComposeFont;
import org.freehep.postscript.CurrentFont;
import org.freehep.postscript.DefineFont;
import org.freehep.postscript.FindEncoding;
import org.freehep.postscript.FindFont;
import org.freehep.postscript.FontCache;
import org.freehep.postscript.GRestore;
import org.freehep.postscript.GSave;
import org.freehep.postscript.GlyphShow;
import org.freehep.postscript.InvalidFont;
import org.freehep.postscript.KShow;
import org.freehep.postscript.MakeFont;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSCharStringDecoder;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSFontDictionary;
import org.freehep.postscript.PSFontID;
import org.freehep.postscript.PSGState;
import org.freehep.postscript.PSGlyph;
import org.freehep.postscript.PSJavaFont;
import org.freehep.postscript.PSJavaGlyph;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSOperator;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.PSType1Glyph;
import org.freehep.postscript.RootFont;
import org.freehep.postscript.ScaleFont;
import org.freehep.postscript.SelectFont;
import org.freehep.postscript.SetCacheDevice;
import org.freehep.postscript.SetCacheDevice2;
import org.freehep.postscript.SetCharWidth;
import org.freehep.postscript.SetFont;
import org.freehep.postscript.Show;
import org.freehep.postscript.StringWidth;
import org.freehep.postscript.UndefineFont;
import org.freehep.postscript.WidthShow;
import org.freehep.postscript.XShow;
import org.freehep.postscript.XYShow;
import org.freehep.postscript.YShow;

public class FontOperator
extends PSOperator {
    protected static FontCache fontCache = new FontCache();
    public static Class[] operators;
    protected PSGlyph currentGlyph;

    protected PSDictionary findFont(PSDictionary fontDirectory, PSName key) {
        PSDictionary font = (PSDictionary)fontDirectory.get(key);
        if (font == null) {
            String fontName = key.getValue();
            String encoding = "STDLatin";
            if (fontName.equals("Symbol")) {
                encoding = "Symbol";
                fontName = "SansSerif.plain";
            } else if (fontName.equals("ZapfDingbats")) {
                encoding = "Zapfdingbats";
                fontName = "SansSerif.plain";
            }
            Font javaFont = fontCache.get(fontName);
            font = new PSFontDictionary(javaFont, encoding);
        }
        return font;
    }

    protected void defineFont(PSDictionary fontDirectory, PSName key, PSDictionary font) {
        font.put("FID", (PSObject)new PSFontID());
        font.changeAccess(2);
        fontDirectory.put((PSObject)key, (PSObject)font);
    }

    protected PSDictionary makeFont(PSDictionary font, double[] matrix) {
        PSJavaFont psfont = (PSJavaFont)font.get("javafont");
        if (psfont == null) {
            double[] cfm = font.getPackedArray("FontMatrix").toDoubles();
            AffineTransform at = new AffineTransform(cfm);
            at.concatenate(new AffineTransform(matrix));
            at.getMatrix(cfm);
            PSDictionary fontCopy = (PSDictionary)font.copy();
            fontCopy.put("FontMatrix", (PSObject)new PSArray(cfm));
            return fontCopy;
        }
        String encoding = font.getString("javaEncoding");
        Font javaFont = psfont.getFont();
        AffineTransform at = new AffineTransform(matrix);
        at.concatenate(javaFont.getTransform());
        javaFont = javaFont.deriveFont(at);
        return new PSFontDictionary(javaFont, encoding);
    }

    protected void setFont(OperandStack os, PSDictionary font) {
        font.put("_CachedGlyphs", (PSObject)new PSDictionary());
        os.gstate().setFont(font);
    }

    protected PSGlyph getCachedGlyph(PSDictionary font, PSName name) {
        PSGlyph glyph;
        PSDictionary cache = font.getDictionary("_CachedGlyphs");
        if (cache == null) {
            cache = new PSDictionary();
            font.put("_CachedGlyphs", (PSObject)cache);
        }
        if ((glyph = (PSGlyph)cache.get(name)) == null) {
            glyph = new PSGlyph();
            cache.put((PSObject)name, (PSObject)glyph);
        }
        font.put("_CurrentGlyph", (PSObject)glyph);
        return glyph;
    }

    protected void show(OperandStack os, int cc) {
        this.show(os, cc, null);
    }

    protected void show(OperandStack os, int cc, PSName name) {
        PSGState gs = os.gstate();
        PSDictionary font = gs.font();
        this.show(os, gs, font, cc, name);
    }

    protected void show(OperandStack os, PSGState gs, PSDictionary font, int cc, PSName name) {
        int type = font.getInteger("FontType");
        PSPackedArray encoding = font.getPackedArray("Encoding");
        if (name == null) {
            name = type == 0 ? new PSName(".notdef") : encoding.getName(cc);
        }
        this.currentGlyph = this.getCachedGlyph(font, name);
        block1 : switch (type) {
            case 0: {
                PSPackedArray fontList = font.getPackedArray("FDepVector");
                PSDictionary currentFont = font.getDictionary("_CurrentFont");
                switch (font.getInteger("FMapType")) {
                    case 2: {
                        if (currentFont == null || font.getBoolean("_ChangeFont")) {
                            currentFont = this.setCurrentFont(cc, font, encoding, fontList);
                            return;
                        }
                        this.show(os, gs, currentFont, cc, null);
                        font.put("_ChangeFont", true);
                        break block1;
                    }
                    case 3: {
                        if (currentFont == null) {
                            currentFont = this.setCurrentFont(0, font, encoding, fontList);
                        }
                        if (font.getBoolean("_ChangeFont")) {
                            currentFont = this.setCurrentFont(cc, font, encoding, fontList);
                            return;
                        }
                        if (cc == font.getInteger("EscChar")) {
                            font.put("_ChangeFont", true);
                            return;
                        }
                        this.show(os, gs, currentFont, cc, null);
                        break block1;
                    }
                    case 4: {
                        currentFont = this.setCurrentFont(cc >> 7 & 1, font, encoding, fontList);
                        this.show(os, gs, currentFont, cc & 0x7F, null);
                        break block1;
                    }
                    case 5: {
                        if (currentFont == null || !font.getBoolean("_ChangeFont")) {
                            font.put("_FontOffset", cc << 1);
                            font.put("_ChangeFont", true);
                            return;
                        }
                        int fontNumber = font.getInteger("_FontOffset");
                        currentFont = this.setCurrentFont(fontNumber += cc >> 7 & 1, font, encoding, fontList);
                        this.show(os, gs, currentFont, cc & 0x7F, null);
                        break block1;
                    }
                    case 6: {
                        System.out.println("Type 0 font with SubsVector Mapping ignored.");
                        break block1;
                    }
                    case 7: {
                        if (currentFont == null) {
                            currentFont = this.setCurrentFont(0, font, encoding, fontList);
                        }
                        if (font.getBoolean("_ChangeFont")) {
                            if (cc == font.getInteger("EscChar")) {
                                font.put("_FontOffset", 256);
                            } else {
                                currentFont = this.setCurrentFont(cc += font.getInteger("_FontOffset"), font, encoding, fontList);
                            }
                            return;
                        }
                        if (cc == font.getInteger("EscChar")) {
                            font.put("_ChangeFont", true);
                            return;
                        }
                        this.show(os, gs, currentFont, cc, null);
                        break block1;
                    }
                    case 8: {
                        if (currentFont == null) {
                            currentFont = this.setCurrentFont(0, font, encoding, fontList);
                            if (font.get("ShiftIn") == null) {
                                font.put("ShiftIn", 15);
                            }
                            if (font.get("ShiftOut") == null) {
                                font.put("ShiftOut", 14);
                            }
                        }
                        if (cc == font.getInteger("ShiftIn")) {
                            currentFont = this.setCurrentFont(0, font, encoding, fontList);
                            return;
                        }
                        if (cc == font.getInteger("ShiftOut")) {
                            currentFont = this.setCurrentFont(1, font, encoding, fontList);
                            return;
                        }
                        this.show(os, gs, currentFont, cc, null);
                        break block1;
                    }
                    case 9: {
                        System.out.println("Type 0 font with CMap Mapping ignored.");
                        break block1;
                    }
                }
                System.out.println("Type 0 font with invalid FMapType " + font.getInteger("FMapType") + " ignored.");
                break;
            }
            case 1: {
                PSDictionary charstrings = font.getDictionary("CharStrings");
                PSObject obj = charstrings.get(name);
                if (obj instanceof PSGlyph) {
                    this.show(os, gs, (PSGlyph)obj);
                    break;
                }
                if (obj instanceof PSPackedArray) {
                    os.push(os.dictStack().systemDictionary());
                    os.push(font);
                    os.push(name);
                    os.execStack().push(obj);
                    break;
                }
                if (obj instanceof PSString) {
                    PSCharStringDecoder decoder = new PSCharStringDecoder(os.dictStack().systemDictionary());
                    try {
                        PSGlyph glyph = decoder.decode((PSString)obj);
                        charstrings.put((PSObject)name, (PSObject)glyph);
                        this.show(os, gs, glyph);
                    }
                    catch (IOException e) {
                        System.err.println("IOError while reading charstring '" + name + "'.");
                    }
                    break;
                }
                System.out.println("Show Ignored " + obj);
                break;
            }
            case 3: {
                PSPackedArray proc = font.getPackedArray("BuildGlyph");
                if (proc != null) {
                    os.push(font);
                    os.push(name);
                } else {
                    proc = font.getPackedArray("BuildChar");
                    os.push(font);
                    os.push(cc);
                }
                os.execStack().push(new GRestore());
                os.execStack().push(proc);
                os.execStack().push(new GSave());
                break;
            }
            default: {
                os.execStack().pop();
                FontOperator.error(os, new InvalidFont());
            }
        }
    }

    private void show(OperandStack os, PSGState gs, PSGlyph g) {
        this.currentGlyph.wy = g.wy;
        this.currentGlyph.wx = g.wx;
        this.currentGlyph.llx = g.llx;
        this.currentGlyph.urx = g.urx;
        if (g instanceof PSJavaGlyph) {
            gs.show(((PSJavaGlyph)g).getGlyph(), (float)(this.currentGlyph.getLSB() * 0.5), 0.0f);
        } else {
            os.execStack().push(new GRestore());
            os.execStack().push(((PSType1Glyph)g).getProc());
            os.execStack().push(new GSave());
        }
    }

    private PSDictionary setCurrentFont(int fontNumber, PSDictionary type0font, PSPackedArray encoding, PSPackedArray fontList) {
        int fontIndex = encoding.getInteger(fontNumber);
        PSDictionary currentFont = fontList.getDictionary(fontIndex);
        type0font.put("_CurrentFont", (PSObject)currentFont);
        type0font.put("_FontOffset", 0);
        type0font.put("_ChangeFont", false);
        return currentFont;
    }

    public static float stringWidth(OperandStack os, int cc) {
        PSName name;
        PSGState gs = os.gstate();
        PSDictionary font = gs.font();
        switch (font.getInteger("FontType")) {
            case 1: 
            case 3: {
                name = font.getPackedArray("Encoding").getName(cc);
                break;
            }
            default: {
                name = new PSName(".notdef");
            }
        }
        return FontOperator.stringWidth(font, name);
    }

    protected static float stringWidth(PSDictionary font, PSName name) {
        PSDictionary metrics = font.getDictionary("Metrics");
        if (metrics == null) {
            return 0.0f;
        }
        PSObject obj = metrics.get(name);
        float width = ((PSNumber)obj).getFloat();
        return width;
    }

    @Override
    public boolean execute(OperandStack os) {
        throw new RuntimeException("Cannot execute class: " + this.getClass());
    }

    static {
        fontCache.put("Courier", fontCache.get("Monospaced.plain"));
        fontCache.put("Courier-Bold", fontCache.get("Monospaced.bold"));
        fontCache.put("Courier-Oblique", fontCache.get("Monospaced.italic"));
        fontCache.put("Courier-BoldOblique", fontCache.get("Monospaced.bolditalic"));
        fontCache.put("Helvetica", fontCache.get("SansSerif.plain"));
        fontCache.put("Helvetica-Bold", fontCache.get("SansSerif.bold"));
        fontCache.put("Helvetica-Oblique", fontCache.get("SansSerif.italic"));
        fontCache.put("Helvetica-BoldOblique", fontCache.get("SansSerif.bolditalic"));
        fontCache.put("Times-Roman", fontCache.get("Serif.plain"));
        fontCache.put("Times-Bold", fontCache.get("Serif.bold"));
        fontCache.put("Times-Italic", fontCache.get("Serif.italic"));
        fontCache.put("Times-BoldItalic", fontCache.get("Serif.bolditalic"));
        operators = new Class[]{DefineFont.class, ComposeFont.class, UndefineFont.class, FindFont.class, ScaleFont.class, MakeFont.class, SetFont.class, RootFont.class, CurrentFont.class, SelectFont.class, Show.class, AShow.class, WidthShow.class, AWidthShow.class, XShow.class, XYShow.class, YShow.class, GlyphShow.class, StringWidth.class, CShow.class, KShow.class, FindEncoding.class, SetCacheDevice.class, SetCacheDevice2.class, SetCharWidth.class};
    }
}

