/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.lang.reflect.Field;
import org.freehep.postscript.ArithmeticOperator;
import org.freehep.postscript.ArrayOperator;
import org.freehep.postscript.ControlOperator;
import org.freehep.postscript.ConversionOperator;
import org.freehep.postscript.DeviceOperator;
import org.freehep.postscript.DictionaryOperator;
import org.freehep.postscript.ErrorOperator;
import org.freehep.postscript.ExtraOperator;
import org.freehep.postscript.FileOperator;
import org.freehep.postscript.FontOperator;
import org.freehep.postscript.FormOperator;
import org.freehep.postscript.GeneralOperator;
import org.freehep.postscript.GraphicsStateOperator;
import org.freehep.postscript.MatrixOperator;
import org.freehep.postscript.MemoryOperator;
import org.freehep.postscript.MiscellaneousOperator;
import org.freehep.postscript.NameLookup;
import org.freehep.postscript.OutputOperator;
import org.freehep.postscript.PSBoolean;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSNull;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSOperator;
import org.freehep.postscript.PackedArrayOperator;
import org.freehep.postscript.PaintingOperator;
import org.freehep.postscript.PathOperator;
import org.freehep.postscript.PostScriptStack;
import org.freehep.postscript.RelationalOperator;
import org.freehep.postscript.StackOperator;
import org.freehep.postscript.StringOperator;

public class DictionaryStack
extends PostScriptStack
implements NameLookup {
    private Class[] operators = new Class[]{GeneralOperator.class, StackOperator.class, ArithmeticOperator.class, ArrayOperator.class, PackedArrayOperator.class, DictionaryOperator.class, StringOperator.class, RelationalOperator.class, ControlOperator.class, ConversionOperator.class, FileOperator.class, GraphicsStateOperator.class, DeviceOperator.class, MatrixOperator.class, MemoryOperator.class, MiscellaneousOperator.class, PathOperator.class, PaintingOperator.class, FormOperator.class, OutputOperator.class, FontOperator.class, ExtraOperator.class};
    private static String[] standardEncodingArray = new String[]{".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "minus", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", ".notdef", "endash", "dagger", "daggerdbl", "periodcentered", ".notdef", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", ".notdef", "questiondown", ".notdef", "grave", "acute", "circonflex", "tilde", "macron", "breve", "dotaccent", "dieresis", ".notdef", "ring", "cedilla", ".notdef", "hungarumlaut", "ogonek", "caron", "emdash", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "AE", ".notdef", "ordfeminine", ".notdef", ".notdef", ".notdef", ".notdef", "Lslash", "Oslash", "OE", "ordmasculine", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "ae", ".notdef", ".notdef", ".notdef", "dotlessi", ".notdef", ".notdef", "lslash", "oslash", "oe", "germandbls", ".notdef", ".notdef", ".notdef", ".notdef"};
    private static String[] isoLatin1EncodingArray = new String[]{".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "minus", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "dotlessi", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", ".notdef", "ring", "cedilla", ".notdef", "hungarumlaut", "ogonek", "caron", "space", "exclamdown", "cent", "sterling", "currency", "yen", "brokenbar", "section", "dieresis", "copyright", "ordfeminine", "guillemotleft", "logicalnot", "hyphen", "registered", "macron", "degree", "plusminus", "twosuperior", "threesuperior", "acute", "mu", "paragraph", "periodcentered", "cedilla", "onesuperior", "ordmasculine", "guillemotright", "onequarter", "onehalf", "threequarters", "questiondown", "Agrave", "Aacute", "Acircumflex", "Atilde", "Adieresis", "Aring", "AE", "Ccedilla", "Egrave", "Eacute", "Ecircumflex", "Edieresis", "Igrave", "Iacute", "Icircumflex", "Idieresis", "Dcroat", "Ntilde", "Ograve", "Oacute", "Ocircumflex", "Otilde", "Odieresis", "multiply", "Oslash", "Ugrave", "Uacute", "Ucircumflex", "Udieresis", "Yacute", "Thorn", "germandbls", "agrave", "aacute", "acircumflex", "atilde", "adieresis", "aring", "ae", "ccedilla", "egrave", "eacute", "ecircumflex", "edieresis", "igrave", "iacute", "icircumflex", "idieresis", "dcroat", "ntilde", "ograve", "oacute", "ocircumflex", "otilde", "odieresis", "divide", "oslash", "ugrave", "uacute", "ucircumflex", "udieresis", "yacute", "thorn", "ydieresis"};
    private PSName errordict = new PSName("errordict");
    private PSName dollarerror = new PSName("$error");
    private PSName systemdict = new PSName("systemdict");
    private PSName userdict = new PSName("userdict");
    private PSName globaldict = new PSName("globaldict");
    private PSName statusdict = new PSName("statusdict");
    private PSName standardEncoding = new PSName("StandardEncoding");
    private PSName isoLatin1Encoding = new PSName("ISOLatin1Encoding");
    private PSName fontDirectory = new PSName("FontDirectory");
    private PSName globalFontDirectory = new PSName("GlobalFontDirectory");

    public DictionaryStack() {
        PSDictionary error = new PSDictionary();
        error.setName("errordict");
        Class[] errorClass = ErrorOperator.operators;
        for (int i = 0; i < errorClass.length; ++i) {
            this.addOperator(error, errorClass[i]);
        }
        PSDictionary dollarErrorDict = new PSDictionary();
        dollarErrorDict.setName("$error");
        dollarErrorDict.put("newerror", (PSObject)new PSBoolean(false));
        dollarErrorDict.put("errorname", (PSObject)new PSNull());
        dollarErrorDict.put("command", (PSObject)new PSNull());
        dollarErrorDict.put("errorinfo", (PSObject)new PSNull());
        dollarErrorDict.put("ostack", (PSObject)new PSNull());
        dollarErrorDict.put("estack", (PSObject)new PSNull());
        dollarErrorDict.put("dstack", (PSObject)new PSNull());
        dollarErrorDict.put("recordstacks", (PSObject)new PSBoolean(true));
        dollarErrorDict.put("binary", (PSObject)new PSBoolean(false));
        PSDictionary user = new PSDictionary();
        user.setName("userdict");
        PSDictionary global = new PSDictionary();
        global.setName("globaldict");
        PSDictionary status = new PSDictionary();
        status.setName("statusdict");
        PSDictionary system = new PSDictionary();
        system.setName("systemdict");
        system.put((PSObject)this.systemdict, (PSObject)system);
        system.put((PSObject)this.errordict, (PSObject)error);
        system.put((PSObject)this.dollarerror, (PSObject)dollarErrorDict);
        system.put((PSObject)this.userdict, (PSObject)user);
        system.put((PSObject)this.statusdict, (PSObject)status);
        system.put((PSObject)this.globaldict, (PSObject)global);
        for (int i = 0; i < this.operators.length; ++i) {
            try {
                Field f = this.operators[i].getField("operators");
                Class[] opClass = (Class[])f.get(null);
                for (int j = 0; j < opClass.length; ++j) {
                    this.addOperator(system, opClass[j]);
                }
                continue;
            }
            catch (NoSuchFieldException e) {
                System.err.println("Error: " + this.operators[i] + " does not have 'operators' field.");
                continue;
            }
            catch (IllegalAccessException e) {
                System.err.println("Error: " + this.operators[i] + ", no access to 'operators' field.");
            }
        }
        system.put(this.standardEncoding, standardEncodingArray);
        system.put(this.isoLatin1Encoding, isoLatin1EncodingArray);
        system.put((PSObject)this.fontDirectory, (PSObject)new PSDictionary());
        system.put((PSObject)this.globalFontDirectory, system.get(this.fontDirectory));
        system.put((PSObject)new PSName("null"), (PSObject)new PSNull());
        system.put((PSObject)new PSName("languagelevel"), (PSObject)new PSInteger(2));
        this.push(system);
        this.push(global);
        this.push(user);
    }

    private void addOperator(PSDictionary dict, Class clazz) {
        try {
            PSOperator op = (PSOperator)clazz.newInstance();
            PSName key = new PSName(op.getName());
            if (dict.get(key) == null) {
                dict.put((PSObject)key, (PSObject)op);
                op.setName(key.cvs());
            } else {
                System.out.println("Duplicate operator '" + key + "'");
                System.exit(1);
            }
        }
        catch (ClassCastException e) {
            System.err.println("Error: " + clazz + " does not inherit from PSOperator.\n" + e);
        }
        catch (IllegalAccessException e) {
            System.err.println("Error: " + clazz + " cannot be instantiated.\n" + e);
        }
        catch (InstantiationException e) {
            System.err.println("Error: " + clazz + " cannot be instantiated.\n" + e);
        }
    }

    @Override
    public Object push(Object o) {
        throw new IllegalArgumentException("Only PSDictionary allowed on stack.");
    }

    public PSDictionary push(PSDictionary d) {
        return (PSDictionary)super.push(d);
    }

    @Override
    public Object pop() {
        if (this.elementCount <= 3) {
            return null;
        }
        return super.pop();
    }

    public PSDictionary popDictionary() {
        return (PSDictionary)this.pop();
    }

    @Override
    public void clear() {
        for (int i = 3; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 3;
    }

    public PSDictionary systemDictionary() {
        return (PSDictionary)this.elementData[0];
    }

    public PSDictionary globalDictionary() {
        return (PSDictionary)this.elementData[1];
    }

    public PSDictionary userDictionary() {
        return (PSDictionary)this.elementData[2];
    }

    public PSDictionary errorDictionary() {
        return (PSDictionary)this.systemDictionary().get(this.errordict);
    }

    public PSDictionary dollarError() {
        return (PSDictionary)this.systemDictionary().get(this.dollarerror);
    }

    public PSDictionary currentDictionary() {
        return (PSDictionary)this.elementData[this.elementCount - 1];
    }

    public PSDictionary fontDirectory() {
        return (PSDictionary)this.systemDictionary().get(this.fontDirectory);
    }

    public PSDictionary globalFontDirectory() {
        return (PSDictionary)this.systemDictionary().get(this.globalFontDirectory);
    }

    public PSDictionary get(PSObject key) {
        for (int i = this.elementCount - 1; i >= 0; --i) {
            PSDictionary d = (PSDictionary)this.elementData[i];
            if (d.get(key) == null) continue;
            return d;
        }
        return null;
    }

    @Override
    public PSObject lookup(PSObject key) {
        PSDictionary d = this.get(key);
        return d != null ? d.get(key) : null;
    }

    @Override
    public void printStack() {
        System.out.println();
        System.out.println("== Top Dictionary Stack ==");
        super.printStack();
        System.out.println("== Bottom Dictionary Stack ==");
    }

    @Override
    public String toString() {
        return "DictionaryStack";
    }
}

