/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.util.List;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.Pair;

class SimplexParameters {
    private List<Pair<Double, MnAlgebraicVector>> theSimplexParameters;
    private int theJHigh;
    private int theJLow;

    SimplexParameters(List<Pair<Double, MnAlgebraicVector>> simpl, int jh, int jl) {
        this.theSimplexParameters = simpl;
        this.theJHigh = jh;
        this.theJLow = jl;
    }

    void update(double y, MnAlgebraicVector p) {
        this.theSimplexParameters.set(this.jh(), new Pair<Double, MnAlgebraicVector>(y, p));
        if (y < (Double)this.theSimplexParameters.get((int)this.jl()).first) {
            this.theJLow = this.jh();
        }
        int jh = 0;
        for (int i = 1; i < this.theSimplexParameters.size(); ++i) {
            if (!((Double)this.theSimplexParameters.get((int)i).first > (Double)this.theSimplexParameters.get((int)jh).first)) continue;
            jh = i;
        }
        this.theJHigh = jh;
    }

    List<Pair<Double, MnAlgebraicVector>> simplex() {
        return this.theSimplexParameters;
    }

    Pair<Double, MnAlgebraicVector> get(int i) {
        return this.theSimplexParameters.get(i);
    }

    int jh() {
        return this.theJHigh;
    }

    int jl() {
        return this.theJLow;
    }

    double edm() {
        return (Double)this.theSimplexParameters.get((int)this.jh()).first - (Double)this.theSimplexParameters.get((int)this.jl()).first;
    }

    MnAlgebraicVector dirin() {
        MnAlgebraicVector dirin = new MnAlgebraicVector(this.theSimplexParameters.size() - 1);
        for (int i = 0; i < this.theSimplexParameters.size() - 1; ++i) {
            double pbig;
            double plit = pbig = ((MnAlgebraicVector)this.theSimplexParameters.get((int)0).second).get(i);
            for (int j = 0; j < this.theSimplexParameters.size(); ++j) {
                if (((MnAlgebraicVector)this.theSimplexParameters.get((int)j).second).get(i) < plit) {
                    plit = ((MnAlgebraicVector)this.theSimplexParameters.get((int)j).second).get(i);
                }
                if (!(((MnAlgebraicVector)this.theSimplexParameters.get((int)j).second).get(i) > pbig)) continue;
                pbig = ((MnAlgebraicVector)this.theSimplexParameters.get((int)j).second).get(i);
            }
            dirin.set(i, pbig - plit);
        }
        return dirin;
    }
}

