/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.util.List;
import org.freehep.math.minuit.FCNBase;
import org.freehep.math.minuit.MnApplication;
import org.freehep.math.minuit.MnParameterScan;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserCovariance;
import org.freehep.math.minuit.MnUserParameterState;
import org.freehep.math.minuit.MnUserParameters;
import org.freehep.math.minuit.ModularFunctionMinimizer;
import org.freehep.math.minuit.Point;
import org.freehep.math.minuit.ScanMinimizer;

public class MnScan
extends MnApplication {
    private ScanMinimizer theMinimizer = new ScanMinimizer();

    public MnScan(FCNBase fcn, double[] par, double[] err) {
        this(fcn, par, err, DEFAULT_STRATEGY);
    }

    public MnScan(FCNBase fcn, double[] par, double[] err, int stra) {
        this(fcn, new MnUserParameterState(par, err), new MnStrategy(stra));
    }

    public MnScan(FCNBase fcn, double[] par, MnUserCovariance cov) {
        this(fcn, par, cov, DEFAULT_STRATEGY);
    }

    public MnScan(FCNBase fcn, double[] par, MnUserCovariance cov, int stra) {
        this(fcn, new MnUserParameterState(par, cov), new MnStrategy(stra));
    }

    public MnScan(FCNBase fcn, MnUserParameters par) {
        this(fcn, par, DEFAULT_STRATEGY);
    }

    public MnScan(FCNBase fcn, MnUserParameters par, int stra) {
        this(fcn, new MnUserParameterState(par), new MnStrategy(stra));
    }

    public MnScan(FCNBase fcn, MnUserParameters par, MnUserCovariance cov) {
        this(fcn, par, cov, DEFAULT_STRATEGY);
    }

    public MnScan(FCNBase fcn, MnUserParameters par, MnUserCovariance cov, int stra) {
        this(fcn, new MnUserParameterState(par, cov), new MnStrategy(stra));
    }

    public MnScan(FCNBase fcn, MnUserParameterState par, MnStrategy str) {
        super(fcn, par, str);
    }

    @Override
    ModularFunctionMinimizer minimizer() {
        return this.theMinimizer;
    }

    public List<Point> scan(int par) {
        return this.scan(par, 41);
    }

    public List<Point> scan(int par, int maxsteps) {
        return this.scan(par, maxsteps, 0.0, 0.0);
    }

    public List<Point> scan(int par, int maxsteps, double low, double high) {
        MnParameterScan scan = new MnParameterScan(this.theFCN, this.theState.parameters());
        double amin = scan.fval();
        List<Point> result = scan.scan(par, maxsteps, low, high);
        if (scan.fval() < amin) {
            this.theState.setValue(par, scan.parameters().value(par));
            amin = scan.fval();
        }
        return result;
    }
}

