/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.util.ArrayList;
import java.util.List;
import org.freehep.math.minuit.FCNBase;
import org.freehep.math.minuit.MnUserParameters;
import org.freehep.math.minuit.Point;

class MnParameterScan {
    private FCNBase theFCN;
    private MnUserParameters theParameters;
    private double theAmin;

    MnParameterScan(FCNBase fcn, MnUserParameters par) {
        this.theFCN = fcn;
        this.theParameters = par;
        this.theAmin = fcn.valueOf(par.params());
    }

    MnParameterScan(FCNBase fcn, MnUserParameters par, double fval) {
        this.theFCN = fcn;
        this.theParameters = par;
        this.theAmin = fval;
    }

    List<Point> scan(int par) {
        return this.scan(par, 41);
    }

    List<Point> scan(int par, int maxsteps) {
        return this.scan(par, maxsteps, 0.0, 0.0);
    }

    List<Point> scan(int par, int maxsteps, double low, double high) {
        if (maxsteps > 101) {
            maxsteps = 101;
        }
        ArrayList<Point> result = new ArrayList<Point>(maxsteps + 1);
        double[] params = this.theParameters.params();
        result.add(new Point(params[par], this.theAmin));
        if (low > high) {
            return result;
        }
        if (maxsteps < 2) {
            return result;
        }
        if (low == 0.0 && high == 0.0) {
            low = params[par] - 2.0 * this.theParameters.error(par);
            high = params[par] + 2.0 * this.theParameters.error(par);
        }
        if (low == 0.0 && high == 0.0 && this.theParameters.parameter(par).hasLimits()) {
            if (this.theParameters.parameter(par).hasLowerLimit()) {
                low = this.theParameters.parameter(par).lowerLimit();
            }
            if (this.theParameters.parameter(par).hasUpperLimit()) {
                high = this.theParameters.parameter(par).upperLimit();
            }
        }
        if (this.theParameters.parameter(par).hasLimits()) {
            if (this.theParameters.parameter(par).hasLowerLimit()) {
                low = Math.max(low, this.theParameters.parameter(par).lowerLimit());
            }
            if (this.theParameters.parameter(par).hasUpperLimit()) {
                high = Math.min(high, this.theParameters.parameter(par).upperLimit());
            }
        }
        double x0 = low;
        double stp = (high - low) / ((double)maxsteps - 1.0);
        for (int i = 0; i < maxsteps; ++i) {
            params[par] = x0 + (double)i * stp;
            double fval = this.theFCN.valueOf(params);
            if (fval < this.theAmin) {
                this.theParameters.setValue(par, params[par]);
                this.theAmin = fval;
            }
            result.add(new Point(params[par], fval));
        }
        return result;
    }

    MnUserParameters parameters() {
        return this.theParameters;
    }

    double fval() {
        return this.theAmin;
    }
}

