/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.MatrixInversionException;
import org.freehep.math.minuit.MnAlgebraicSymMatrix;
import org.freehep.math.minuit.MnPrint;

public class MnGlobalCorrelationCoeff {
    private double[] theGlobalCC;
    private boolean theValid;

    MnGlobalCorrelationCoeff() {
        this.theGlobalCC = new double[0];
    }

    MnGlobalCorrelationCoeff(MnAlgebraicSymMatrix cov) {
        try {
            MnAlgebraicSymMatrix inv = cov.clone();
            inv.invert();
            this.theGlobalCC = new double[cov.nrow()];
            for (int i = 0; i < cov.nrow(); ++i) {
                double denom = inv.get(i, i) * cov.get(i, i);
                this.theGlobalCC[i] = denom < 1.0 && denom > 0.0 ? 0.0 : Math.sqrt(1.0 - 1.0 / denom);
            }
            this.theValid = true;
        }
        catch (MatrixInversionException x) {
            this.theValid = false;
            this.theGlobalCC = new double[0];
        }
    }

    public double[] globalCC() {
        return this.theGlobalCC;
    }

    public boolean isValid() {
        return this.theValid;
    }

    public String toString() {
        return MnPrint.toString(this);
    }
}

