/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.MatrixInversionException;
import org.freehep.math.minuit.MnAlgebraicSymMatrix;
import org.freehep.math.minuit.MnUtils;

class MinimumError {
    private MnAlgebraicSymMatrix theMatrix;
    private double theDCovar;
    private boolean theValid;
    private boolean thePosDef;
    private boolean theMadePosDef;
    private boolean theHesseFailed;
    private boolean theInvertFailed;
    private boolean theAvailable;

    MinimumError(int n) {
        this.theMatrix = new MnAlgebraicSymMatrix(n);
        this.theDCovar = 1.0;
    }

    MinimumError(MnAlgebraicSymMatrix mat, double dcov) {
        this.theMatrix = mat;
        this.theDCovar = dcov;
        this.theValid = true;
        this.thePosDef = true;
        this.theAvailable = true;
    }

    MinimumError(MnAlgebraicSymMatrix mat, MnHesseFailed x) {
        this.theMatrix = mat;
        this.theDCovar = 1.0;
        this.theValid = false;
        this.thePosDef = false;
        this.theMadePosDef = false;
        this.theHesseFailed = true;
        this.theInvertFailed = false;
        this.theAvailable = true;
    }

    MinimumError(MnAlgebraicSymMatrix mat, MnMadePosDef x) {
        this.theMatrix = mat;
        this.theDCovar = 1.0;
        this.theValid = false;
        this.thePosDef = false;
        this.theMadePosDef = true;
        this.theHesseFailed = false;
        this.theInvertFailed = false;
        this.theAvailable = true;
    }

    MinimumError(MnAlgebraicSymMatrix mat, MnInvertFailed x) {
        this.theMatrix = mat;
        this.theDCovar = 1.0;
        this.theValid = false;
        this.thePosDef = true;
        this.theMadePosDef = false;
        this.theHesseFailed = false;
        this.theInvertFailed = true;
        this.theAvailable = true;
    }

    MinimumError(MnAlgebraicSymMatrix mat, MnNotPosDef x) {
        this.theMatrix = mat;
        this.theDCovar = 1.0;
        this.theValid = false;
        this.thePosDef = false;
        this.theMadePosDef = false;
        this.theHesseFailed = false;
        this.theInvertFailed = false;
        this.theAvailable = true;
    }

    MnAlgebraicSymMatrix matrix() {
        return MnUtils.mul(this.theMatrix, 2.0);
    }

    MnAlgebraicSymMatrix invHessian() {
        return this.theMatrix;
    }

    MnAlgebraicSymMatrix hessian() {
        try {
            MnAlgebraicSymMatrix tmp = this.theMatrix.clone();
            tmp.invert();
            return tmp;
        }
        catch (MatrixInversionException x) {
            System.err.println("BasicMinimumError inversion fails; return diagonal matrix.");
            MnAlgebraicSymMatrix tmp = new MnAlgebraicSymMatrix(this.theMatrix.nrow());
            for (int i = 0; i < this.theMatrix.nrow(); ++i) {
                tmp.set(i, i, 1.0 / this.theMatrix.get(i, i));
            }
            return tmp;
        }
    }

    double dcovar() {
        return this.theDCovar;
    }

    boolean isAccurate() {
        return this.theDCovar < 0.1;
    }

    boolean isValid() {
        return this.theValid;
    }

    boolean isPosDef() {
        return this.thePosDef;
    }

    boolean isMadePosDef() {
        return this.theMadePosDef;
    }

    boolean hesseFailed() {
        return this.theHesseFailed;
    }

    boolean invertFailed() {
        return this.theInvertFailed;
    }

    boolean isAvailable() {
        return this.theAvailable;
    }

    static class MnInvertFailed {
        MnInvertFailed() {
        }
    }

    static class MnHesseFailed {
        MnHesseFailed() {
        }
    }

    static class MnMadePosDef {
        MnMadePosDef() {
        }
    }

    static class MnNotPosDef {
        MnNotPosDef() {
        }
    }
}

