/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.io.IOException;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.graphicsio.cgm.CGMWriter;

public class InteriorStyle
extends CGMTag {
    public static final int HOLLOW = 0;
    public static final int SOLID = 1;
    public static final int PATTERN = 2;
    public static final int HATCH = 3;
    public static final int EMPTY = 4;
    public static final int GEOMETRIC_PATTERN = 5;
    public static final int INTERPOLATED = 6;
    private int style;

    public InteriorStyle() {
        super(5, 22, 1);
    }

    public InteriorStyle(int style) {
        this();
        this.style = style;
    }

    @Override
    public void write(int tagID, CGMOutputStream cgm) throws IOException {
        cgm.writeEnumerate(this.style);
    }

    @Override
    public void write(int tagID, CGMWriter cgm) throws IOException {
        cgm.print("INTSTYLE ");
        switch (this.style) {
            default: {
                cgm.print("HOLLOW");
                break;
            }
            case 1: {
                cgm.print("SOLID");
                break;
            }
            case 2: {
                cgm.print("PAT");
                break;
            }
            case 3: {
                cgm.print("HATCH");
                break;
            }
            case 4: {
                cgm.print("EMPTY");
                break;
            }
            case 5: {
                cgm.print("GEOPAT");
                break;
            }
            case 6: {
                cgm.print("INTERP");
            }
        }
    }
}

