/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.aid;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.freehep.aid.AbstractCPPHeaderGenerator;
import org.freehep.rtti.IClass;
import org.freehep.rtti.IConstructor;
import org.freehep.rtti.IField;
import org.freehep.rtti.IMethod;
import org.freehep.rtti.INamedType;
import org.freehep.util.io.IndentPrintWriter;

public class JNIHeaderGenerator
extends AbstractCPPHeaderGenerator {
    public JNIHeaderGenerator(String propDir) {
        super(propDir);
        this.properties.setProperty("jni", "true");
        this.properties.setProperty("jni.header", "true");
    }

    @Override
    protected String prefix() {
        return "J";
    }

    @Override
    public String filename(IClass clazz) {
        return this.prefix() + clazz.getName() + ".h";
    }

    @Override
    protected void includeStatements(IClass clazz, SortedSet sysIncludes, SortedSet includes, String namespace, SortedSet types) {
        sysIncludes.add("jni.h");
        String iface = this.converter.qualifiedName(clazz.getName(), this.prefix() + this.namespace(clazz));
        includes.add(this.includeProperties.getProperty(iface, iface));
        String[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            includes.add(this.prefix() + interfaces[i] + ".h");
        }
        IConstructor[] constructors = clazz.getConstructors();
        for (int c = 0; c < constructors.length; ++c) {
            INamedType[] parameterTypes = constructors[c].getParameterTypes();
            for (int p = 0; p < parameterTypes.length; ++p) {
                this.includeFrom(parameterTypes[p].getType(), clazz.getName(), sysIncludes, includes, this.prefix() + namespace, types);
            }
        }
        super.includeStatements(clazz, sysIncludes, includes, this.prefix() + namespace, types);
        if (interfaces.length == 0) {
            includes.add("JAID/JAIDRef.h");
        }
    }

    @Override
    protected void printClassHeader(IndentPrintWriter out, IClass clazz) {
        out.print("class " + this.prefix() + clazz.getName() + ": ");
        String[] interfaces = clazz.getInterfaces();
        if (interfaces.length == 0) {
            out.print("public JAID::JAIDRef");
        } else {
            int k = 0;
            for (int i = 0; i < interfaces.length; ++i) {
                if (k > 0) {
                    out.print(", ");
                }
                out.print("public ");
                out.print(this.prefix() + interfaces[i]);
                ++k;
            }
        }
        out.print(", public virtual ");
        out.print(this.converter.qualifiedName(clazz.getName(), this.prefix() + this.namespace(clazz)));
        out.println(" {");
    }

    @Override
    protected void printPrivate(IndentPrintWriter out, IClass clazz) {
        HashMap<String, IMethod> methods = new HashMap<String, IMethod>();
        for (int i = 0; i < clazz.getMethods().length; ++i) {
            IMethod m = clazz.getMethods()[i];
            String name = m.getName() + this.converter.getSignature(m, clazz.getPackageName());
            methods.put(name, m);
        }
        if (!methods.isEmpty()) {
            out.println();
            out.println("private: ");
        }
        for (Map.Entry entry : methods.entrySet()) {
            out.print("    jmethodID " + entry.getKey() + "Method");
            out.println(";");
        }
    }

    @Override
    protected void printProtected(IndentPrintWriter out, IClass clazz) {
        String name = this.prefix() + clazz.getName();
        out.println();
        out.println("protected:");
        out.println("    inline " + name + "() { };");
        out.println("    inline " + name + "(const " + name + "& r) { };");
        out.println("    inline " + name + "& operator=(const " + name + "&) { return *this; };");
    }

    @Override
    protected void printPublic(IndentPrintWriter out, IClass clazz) {
        out.println();
        out.println("public: ");
        out.println("    /**");
        out.println("     * Default JNI Constructor");
        out.println("     */");
        out.println("    " + this.prefix() + clazz.getName() + "(JNIEnv *env, jobject object);");
        out.println();
        out.println("    /// Destructor.");
        out.println("    virtual ~" + this.prefix() + clazz.getName() + "();");
    }

    @Override
    protected void printConstructor(IndentPrintWriter out, IConstructor constructor, String nameSpace) {
        String[] comments = constructor.getComments("cpp");
        for (int i = 0; i < comments.length; ++i) {
            out.print(comments[i]);
        }
        out.print("    ");
        out.print(this.prefix() + constructor.getName());
        out.print("(");
        INamedType[] parameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            out.print(this.namedType(parameterTypes[i], nameSpace));
            if (i >= parameterTypes.length - 1) continue;
            out.print(", ");
        }
        out.print(");");
    }

    @Override
    protected void printMethod(IndentPrintWriter out, IMethod method, String nameSpace) {
        super.printMethod(out, method, this.prefix() + nameSpace);
        out.println(";");
    }

    @Override
    protected void printField(IndentPrintWriter out, IField ifield, String nameSpace) {
    }

    @Override
    protected boolean printDefines(IndentPrintWriter out, IClass clazz) {
        return true;
    }
}

