/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.vec;

import hep.physics.vec.Hep3Vector;
import hep.physics.vec.VecOp;
import java.io.Serializable;
import org.apache.commons.math3.util.FastMath;

public class BasicHep3Vector
implements Hep3Vector,
Serializable {
    static final long serialVersionUID = -52454965658870098L;
    private double x;
    private double y;
    private double z;

    public BasicHep3Vector() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public BasicHep3Vector(double dx, double dy, double dz) {
        this.x = dx;
        this.y = dy;
        this.z = dz;
    }

    public BasicHep3Vector(double[] d) {
        if (d.length != 3) {
            throw new IllegalArgumentException("Illegal array length");
        }
        this.x = d[0];
        this.y = d[1];
        this.z = d[2];
    }

    public BasicHep3Vector(float[] f) {
        if (f.length != 3) {
            throw new IllegalArgumentException("Illegal array length");
        }
        this.x = f[0];
        this.y = f[1];
        this.z = f[2];
    }

    public void setV(double dx, double dy, double dz) {
        this.x = dx;
        this.y = dy;
        this.z = dz;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public double magnitude() {
        return FastMath.sqrt((double)(this.x * this.x + this.y * this.y + this.z * this.z));
    }

    @Override
    public double magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @Override
    public double[] v() {
        return new double[]{this.x, this.y, this.z};
    }

    public boolean equals(Object obj) {
        if (obj instanceof Hep3Vector) {
            Hep3Vector that = (Hep3Vector)obj;
            return this.x == that.x() && this.y == that.y() && this.z == that.z();
        }
        return false;
    }

    public String toString() {
        return VecOp.toString(this);
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.x) + Double.doubleToLongBits(this.y) + Double.doubleToLongBits(this.z));
    }
}

