/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.matrix;

import hep.physics.matrix.BasicMatrix;
import hep.physics.matrix.Matrix;
import hep.physics.matrix.MutableMatrix;
import hep.physics.vec.BasicHep3Vector;
import hep.physics.vec.Hep3Vector;
import java.util.Formatter;

public class MatrixOp {
    private MatrixOp() {
    }

    public static void inverse(Matrix mIn, MutableMatrix mOut) throws InvalidMatrixException {
        int j;
        int i;
        int i2;
        int order = mIn.getNRows();
        if (order != mIn.getNColumns()) {
            throw new InvalidMatrixException("Matrix.inverse only supports square matrices");
        }
        if (order != mOut.getNColumns() && order != mOut.getNRows()) {
            throw new InvalidMatrixException("mOut must be same size as mIn");
        }
        int[] ik = new int[order];
        int[] jk = new int[order];
        double[][] array = new double[order][order];
        for (i2 = 0; i2 < order; ++i2) {
            for (int j2 = 0; j2 < order; ++j2) {
                array[i2][j2] = mIn.e(i2, j2);
            }
        }
        for (int k = 0; k < order; ++k) {
            double save;
            int j3;
            double amax = 0.0;
            for (i = k; i < order; ++i) {
                for (j3 = k; j3 < order; ++j3) {
                    if (!(Math.abs(array[i][j3]) > Math.abs(amax))) continue;
                    amax = array[i][j3];
                    ik[k] = i;
                    jk[k] = j3;
                }
            }
            if (amax == 0.0) {
                throw new IndeterminateMatrixException();
            }
            i = ik[k];
            assert (k <= i);
            if (i > k) {
                for (j3 = 0; j3 < order; ++j3) {
                    save = array[k][j3];
                    array[k][j3] = array[i][j3];
                    array[i][j3] = -save;
                }
            }
            j = jk[k];
            assert (k <= j);
            if (j > k) {
                for (int i3 = 0; i3 < order; ++i3) {
                    save = array[i3][k];
                    array[i3][k] = array[i3][j];
                    array[i3][j] = -save;
                }
            }
            for (i = 0; i < order; ++i) {
                if (i == k) continue;
                array[i][k] = -array[i][k] / amax;
            }
            for (i = 0; i < order; ++i) {
                if (i == k) continue;
                for (j3 = 0; j3 < order; ++j3) {
                    if (j3 == k) continue;
                    double[] dArray = array[i];
                    int n = j3;
                    dArray[n] = dArray[n] + array[i][k] * array[k][j3];
                }
            }
            for (j = 0; j < order; ++j) {
                if (j == k) continue;
                array[k][j] = array[k][j] / amax;
            }
            array[k][k] = 1.0 / amax;
        }
        for (int l = 0; l < order; ++l) {
            int i4;
            int k = order - l - 1;
            int j4 = ik[k];
            if (j4 > k) {
                for (i = 0; i < order; ++i) {
                    double save = array[i][k];
                    array[i][k] = -array[i][j4];
                    array[i][j4] = save;
                }
            }
            if ((i4 = jk[k]) <= k) continue;
            for (j = 0; j < order; ++j) {
                double save = array[k][j];
                array[k][j] = -array[i4][j];
                array[i4][j] = save;
            }
        }
        for (i2 = 0; i2 < order; ++i2) {
            for (int j5 = 0; j5 < order; ++j5) {
                mOut.setElement(i2, j5, array[i2][j5]);
            }
        }
    }

    public static Matrix inverse(Matrix m) {
        BasicMatrix minv = new BasicMatrix(m.getNRows(), m.getNColumns());
        MatrixOp.inverse(m, minv);
        return minv;
    }

    public static String toString(Matrix m) {
        Formatter formatter = new Formatter();
        formatter.format("[", new Object[0]);
        int i = 0;
        while (true) {
            formatter.format("[", new Object[0]);
            int j = 0;
            while (true) {
                formatter.format("%12.5g", m.e(i, j));
                if (++j >= m.getNColumns()) break;
                formatter.format(",", new Object[0]);
            }
            if (++i >= m.getNRows()) break;
            formatter.format("]\n ", new Object[0]);
        }
        formatter.format("]", new Object[0]);
        return formatter.out().toString();
    }

    public static double det(Matrix mIn) {
        int order = mIn.getNRows();
        if (order != mIn.getNColumns()) {
            throw new InvalidMatrixException("Matrix.det only supports square matrices");
        }
        int[] ik = new int[order];
        int[] jk = new int[order];
        double[][] array = new double[order][order];
        for (int i = 0; i < order; ++i) {
            for (int j = 0; j < order; ++j) {
                array[i][j] = mIn.e(i, j);
            }
        }
        double det = 1.0;
        for (int k = 0; k < order; ++k) {
            double save;
            int j;
            int i;
            double amax = 0.0;
            for (i = k; i < order; ++i) {
                for (j = k; j < order; ++j) {
                    if (!(Math.abs(array[i][j]) > Math.abs(amax))) continue;
                    amax = array[i][j];
                    ik[k] = i;
                    jk[k] = j;
                }
            }
            if (amax == 0.0) {
                return 0.0;
            }
            i = ik[k];
            assert (k <= i);
            if (i > k) {
                for (j = 0; j < order; ++j) {
                    save = array[k][j];
                    array[k][j] = array[i][j];
                    array[i][j] = -save;
                }
            }
            int j2 = jk[k];
            assert (k <= j2);
            if (j2 > k) {
                for (int i2 = 0; i2 < order; ++i2) {
                    save = array[i2][k];
                    array[i2][k] = array[i2][j2];
                    array[i2][j2] = -save;
                }
            }
            for (i = 0; i < order; ++i) {
                if (i == k) continue;
                array[i][k] = -array[i][k] / amax;
            }
            for (i = 0; i < order; ++i) {
                if (i == k) continue;
                for (j = 0; j < order; ++j) {
                    if (j == k) continue;
                    double[] dArray = array[i];
                    int n = j;
                    dArray[n] = dArray[n] + array[i][k] * array[k][j];
                }
            }
            for (j2 = 0; j2 < order; ++j2) {
                if (j2 == k) continue;
                array[k][j2] = array[k][j2] / amax;
            }
            array[k][k] = 1.0 / amax;
            det *= amax;
        }
        return det;
    }

    public static void transposed(Matrix mIn, MutableMatrix mOut) {
        if (mIn.getNRows() != mOut.getNColumns() || mIn.getNColumns() != mOut.getNRows()) {
            throw new InvalidMatrixException("Incompatible matrixes for transposed");
        }
        if (mOut == mIn) {
            int order = mIn.getNRows();
            for (int i = 0; i < order; ++i) {
                for (int j = 0; j < i; ++j) {
                    double t1 = mIn.e(i, j);
                    mOut.setElement(i, j, mIn.e(j, i));
                    mOut.setElement(j, i, t1);
                }
                mOut.setElement(i, i, mIn.e(i, i));
            }
        } else {
            for (int i = 0; i < mIn.getNRows(); ++i) {
                for (int j = 0; j < mIn.getNColumns(); ++j) {
                    mOut.setElement(j, i, mIn.e(i, j));
                }
            }
        }
    }

    public static Matrix transposed(Matrix m) {
        BasicMatrix mt = new BasicMatrix(m.getNColumns(), m.getNRows());
        for (int i = 0; i < m.getNRows(); ++i) {
            for (int j = 0; j < m.getNColumns(); ++j) {
                mt.setElement(j, i, m.e(i, j));
            }
        }
        return mt;
    }

    public static Matrix mult(Matrix m1, Matrix m2) {
        int nAdd = m1.getNColumns();
        if (nAdd != m2.getNRows()) {
            throw new InvalidMatrixException("Incompatible matrices for multiplication");
        }
        int nRows = m1.getNRows();
        int nCols = m2.getNColumns();
        BasicMatrix result = new BasicMatrix(nRows, nCols);
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < nAdd; ++k) {
                    sum += m1.e(i, k) * m2.e(k, j);
                }
                result.setElement(i, j, sum);
            }
        }
        return result;
    }

    public static Matrix add(Matrix a, Matrix b) {
        if (a.getNRows() != b.getNRows() || a.getNColumns() != b.getNColumns()) {
            throw new InvalidMatrixException("Trying to add two matrices with different dimensions");
        }
        BasicMatrix c = new BasicMatrix(a.getNRows(), a.getNColumns());
        for (int i = 0; i < a.getNRows(); ++i) {
            for (int j = 0; j < a.getNColumns(); ++j) {
                c.setElement(i, j, a.e(i, j) + b.e(i, j));
            }
        }
        return c;
    }

    public static Matrix sub(Matrix a, Matrix b) {
        if (a.getNRows() != b.getNRows() || a.getNColumns() != b.getNColumns()) {
            throw new InvalidMatrixException("Trying to add two matrices with different dimensions");
        }
        BasicMatrix c = new BasicMatrix(a.getNRows(), a.getNColumns());
        for (int i = 0; i < a.getNRows(); ++i) {
            for (int j = 0; j < a.getNColumns(); ++j) {
                c.setElement(i, j, a.e(i, j) - b.e(i, j));
            }
        }
        return c;
    }

    public static Matrix mult(double c, Matrix m) {
        BasicMatrix b = new BasicMatrix(m.getNRows(), m.getNColumns());
        for (int i = 0; i < m.getNRows(); ++i) {
            for (int j = 0; j < m.getNColumns(); ++j) {
                b.setElement(i, j, c * m.e(i, j));
            }
        }
        return b;
    }

    public static void setSubMatrix(MutableMatrix mat, Matrix sub, int row, int col) {
        if (row < 0 || col < 0 || sub.getNRows() + row > mat.getNRows() || sub.getNColumns() + col > mat.getNColumns()) {
            throw new InvalidMatrixException("Invalid attempt to insert a submatrix into a matrix");
        }
        for (int i = 0; i < sub.getNRows(); ++i) {
            for (int j = 0; j < sub.getNColumns(); ++j) {
                mat.setElement(i + row, j + col, sub.e(i, j));
            }
        }
    }

    public static Matrix getSubMatrix(Matrix m, int row, int col, int nrow, int ncol) {
        if (row < 0 || row + nrow > m.getNRows() || col < 0 || col + ncol > m.getNColumns()) {
            throw new InvalidMatrixException("Invalid attempt to get a submatrix from a matrix");
        }
        BasicMatrix sm = new BasicMatrix(nrow, ncol);
        for (int i = 0; i < nrow; ++i) {
            for (int j = 0; j < ncol; ++j) {
                sm.setElement(i, j, m.e(i + row, j + col));
            }
        }
        return sm;
    }

    public static Hep3Vector as3Vector(Matrix m) {
        if (m.getNRows() != 3 || m.getNColumns() != 1) {
            throw new InvalidMatrixException("Invalid attempt to form a vector from a matrix");
        }
        return new BasicHep3Vector(m.e(0, 0), m.e(1, 0), m.e(2, 0));
    }

    public static class InvalidMatrixException
    extends RuntimeException {
        public InvalidMatrixException(String message) {
            super(message);
        }
    }

    public static class IndeterminateMatrixException
    extends InvalidMatrixException {
        public IndeterminateMatrixException() {
            super("Matrix is indeterminate");
        }
    }
}

