/*
 * Decompiled with CFR 0.152.
 */
package hep.io.stdhep;

import hep.io.stdhep.StdhepEvent;
import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import java.io.IOException;

public class StdhepExtendedEvent
extends StdhepEvent {
    private double eventweight;
    private double alphaqed;
    private double alphaqcd;
    private double[] scale;
    private double[] spin;
    private int[] colorflow;
    private int idrup;

    public StdhepExtendedEvent(int nevhep, int nhep, int[] isthep, int[] idhep, int[] jmohep, int[] jdahep, double[] phep, double[] vhep, double eventweight, double alphaqed, double alphaqcd, double[] scale, double[] spin, int[] colorflow, int idrup) {
        super(201, nevhep, nhep, isthep, idhep, jmohep, jdahep, phep, vhep);
        this.eventweight = eventweight;
        this.alphaqed = alphaqed;
        this.alphaqcd = alphaqcd;
        this.scale = scale;
        this.spin = spin;
        this.colorflow = colorflow;
        this.idrup = idrup;
    }

    StdhepExtendedEvent() {
        super(201);
    }

    public double getEventWeight() {
        return this.eventweight;
    }

    public double getAlphaQED() {
        return this.alphaqed;
    }

    public double getAlphaQCD() {
        return this.alphaqcd;
    }

    public double getScale(int i) {
        return this.scale[i];
    }

    public double getSpin(int index, int i) {
        return this.spin[index * 3 + i];
    }

    public int getColorFlow(int index, int i) {
        return this.colorflow[index * 2 + i];
    }

    public int getIDRUP() {
        return this.idrup;
    }

    @Override
    public void read(XDRDataInput xdr) throws IOException {
        super.read(xdr);
        this.eventweight = xdr.readDouble();
        this.alphaqed = xdr.readDouble();
        this.alphaqcd = xdr.readDouble();
        this.scale = xdr.readDoubleArray(this.scale);
        this.spin = xdr.readDoubleArray(this.spin);
        this.colorflow = xdr.readIntArray(this.colorflow);
        this.idrup = xdr.readInt();
    }

    @Override
    public void write(XDRDataOutput xdr) throws IOException {
        super.write(xdr);
        int nhep = super.getNHEP();
        xdr.writeDouble(this.eventweight);
        xdr.writeDouble(this.alphaqed);
        xdr.writeDouble(this.alphaqcd);
        xdr.writeDoubleArray(this.scale, 0, 5);
        xdr.writeDoubleArray(this.spin, 0, 3 * nhep);
        xdr.writeIntArray(this.colorflow, 0, 2 * nhep);
        xdr.writeInt(this.idrup);
    }
}

