/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep1.xml;

import hep.graphics.heprep1.HepRep;
import hep.graphics.heprep1.HepRepAttDef;
import hep.graphics.heprep1.HepRepAttValue;
import hep.graphics.heprep1.HepRepAttribute;
import hep.graphics.heprep1.HepRepInstance;
import hep.graphics.heprep1.HepRepPoint;
import hep.graphics.heprep1.HepRepPrimitive;
import hep.graphics.heprep1.HepRepType;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import org.freehep.util.ScientificFormat;
import org.freehep.xml.util.XMLWriter;

public class XMLHepRepWriter
extends XMLWriter {
    private ScientificFormat scientific;
    private String[] labelStrings = new String[]{"NAME", "DESC", "VALUE", "EXTRA"};

    public XMLHepRepWriter(Writer out) {
        super(out);
        this.scientific = new ScientificFormat();
        this.openDoc();
    }

    @Override
    public void close() throws IOException {
        this.closeDoc();
        super.close();
    }

    public void write(HepRep root) {
        this.setAttribute("xmlns:heprep", "http://www.freehep.org/HepRep");
        this.setAttribute("xmlns:xsi", "http://www.w3.org/1999/XMLSchema-instance");
        this.setAttribute("xsi:schemaLocation", "HepRep.xsd");
        this.openTag("heprep:heprep");
        this.write((HepRepAttribute)root);
        Enumeration e = root.getTypes();
        while (e.hasMoreElements()) {
            HepRepType type = (HepRepType)e.nextElement();
            this.write(type);
        }
        this.closeTag();
    }

    public void write(HepRepType type) {
        this.setAttribute("name", type.getName());
        this.setAttribute("version", type.getVersion());
        this.openTag("heprep:type");
        this.write((HepRepAttribute)type);
        Enumeration e = type.getTypes();
        while (e.hasMoreElements()) {
            HepRepType subType = (HepRepType)e.nextElement();
            this.write(subType);
        }
        e = type.getInstances();
        while (e.hasMoreElements()) {
            HepRepInstance instance = (HepRepInstance)e.nextElement();
            this.write(instance);
        }
        this.closeTag();
    }

    public void write(HepRepInstance instance) {
        this.openTag("heprep:instance");
        this.write((HepRepAttribute)instance);
        Enumeration e = instance.getTypes();
        while (e.hasMoreElements()) {
            HepRepType type = (HepRepType)e.nextElement();
            this.write(type);
        }
        e = instance.getPrimitives();
        while (e.hasMoreElements()) {
            HepRepPrimitive primitive = (HepRepPrimitive)e.nextElement();
            this.write(primitive);
        }
        this.closeTag();
    }

    public void write(HepRepPrimitive primitive) {
        this.openTag("heprep:primitive");
        this.write((HepRepAttribute)primitive);
        Enumeration e = primitive.getPoints();
        while (e.hasMoreElements()) {
            HepRepPoint point = (HepRepPoint)e.nextElement();
            this.write(point);
        }
        this.closeTag();
    }

    public void write(HepRepPoint point) {
        this.setAttribute("x", this.scientific.format(point.getX()));
        this.setAttribute("y", this.scientific.format(point.getY()));
        this.setAttribute("z", this.scientific.format(point.getZ()));
        this.openTag("heprep:point");
        this.write((HepRepAttribute)point);
        this.closeTag();
    }

    public void write(HepRepAttValue attValue) {
        this.setAttribute("name", attValue.getName());
        this.setAttribute("value", attValue.getString());
        String label = null;
        int showLabel = attValue.showLabel();
        if (showLabel == 0) {
            label = "NONE";
        } else {
            for (int i = 0; i < 16; ++i) {
                if ((showLabel >> i & 1) != 1) continue;
                label = label == null ? "" : label + ", ";
                label = i < this.labelStrings.length ? label + this.labelStrings[i] : label + "0x" + Integer.toHexString(1 << i);
            }
        }
        this.setAttribute("showLabel", label);
        this.printTag("heprep:attvalue");
    }

    public void write(HepRepAttDef attDef) {
        this.setAttribute("name", attDef.getName());
        this.setAttribute("desc", attDef.getDescription());
        this.setAttribute("type", attDef.getType());
        this.setAttribute("extra", attDef.getExtra());
        this.printTag("heprep:attdef");
    }

    public void write(HepRepAttribute attribute) {
        Enumeration e = attribute.getAttValues();
        while (e.hasMoreElements()) {
            HepRepAttValue attValue = (HepRepAttValue)e.nextElement();
            this.write(attValue);
        }
        e = attribute.getAttDefs();
        while (e.hasMoreElements()) {
            HepRepAttDef attDef = (HepRepAttDef)e.nextElement();
            this.write(attDef);
        }
    }
}

