/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep1.adapter;

import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.ref.DefaultHepRepAttValue;
import hep.graphics.heprep.util.HepRepColor;
import hep.graphics.heprep.xml.XMLHepRepFactory;
import hep.graphics.heprep1.HepRep;
import hep.graphics.heprep1.HepRepAttDef;
import hep.graphics.heprep1.HepRepAttValue;
import hep.graphics.heprep1.HepRepPoint;
import hep.graphics.heprep1.HepRepPrimitive;
import hep.graphics.heprep1.adapter.AttributeNameTranslator;
import hep.graphics.heprep1.adapter.HepRepAdapter;
import hep.graphics.heprep1.adapter.HepRepAttDefAdapter;
import hep.graphics.heprep1.adapter.HepRepAttValueAdapter;
import hep.graphics.heprep1.adapter.HepRepInstanceFromHepRepAdapter;
import hep.graphics.heprep1.adapter.HepRepInstanceFromInstanceAdapter;
import hep.graphics.heprep1.adapter.HepRepInstanceFromPrimitiveAdapter;
import hep.graphics.heprep1.adapter.HepRepPointAdapter;
import hep.graphics.heprep1.adapter.HepRepTypeFromHepRepAdapter;
import hep.graphics.heprep1.adapter.HepRepTypeFromInstanceAdapter;
import hep.graphics.heprep1.adapter.HepRepTypeFromTypeAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class HepRepAdapterFactory
extends XMLHepRepFactory {
    private static HepRepAdapterFactory factory;
    private static Map valueTranslator;

    private HepRepAdapterFactory() {
    }

    public static HepRepAdapterFactory getFactory() {
        if (factory == null) {
            factory = new HepRepAdapterFactory();
        }
        return factory;
    }

    public hep.graphics.heprep.HepRep createHepRep(HepRep heprep1) {
        return new HepRepAdapter(heprep1);
    }

    public hep.graphics.heprep.HepRepAttValue createHepRepAttValue(HepRepAttValue value1) {
        if (value1 == null) {
            return null;
        }
        String name = AttributeNameTranslator.getName2(value1.getName());
        String type = DefaultHepRepAttValue.guessType(name, value1.getString(), null);
        int typeCode = DefaultHepRepAttValue.toType(type);
        switch (typeCode) {
            case 2: {
                return new HepRepAttValueAdapter(value1, name, HepRepColor.get(value1.getString()), value1.showLabel());
            }
            case 10: {
                return new HepRepAttValueAdapter(value1, name, value1.getLong(), value1.showLabel());
            }
            case 11: {
                return new HepRepAttValueAdapter(value1, name, value1.getInteger(), value1.showLabel());
            }
            case 20: {
                return new HepRepAttValueAdapter(value1, name, value1.getDouble(), value1.showLabel());
            }
            case 30: {
                return new HepRepAttValueAdapter(value1, name, value1.getBoolean(), value1.showLabel());
            }
            case 1: {
                String s = value1.getString();
                Map translations = (Map)valueTranslator.get(name.toLowerCase());
                if (translations != null) {
                    for (String key : translations.keySet()) {
                        String value = (String)translations.get(key);
                        Pattern pattern = Pattern.compile(key, 2);
                        s = pattern.matcher(s).replaceAll(value);
                    }
                }
                return new HepRepAttValueAdapter(value1, name, s, value1.showLabel());
            }
        }
        System.err.println("Unknown type in DefaultHepRepAttValue: '" + type + "'");
        return new HepRepAttValueAdapter(value1, name, value1.getString(), value1.showLabel());
    }

    public hep.graphics.heprep.HepRepAttDef createHepRepAttDef(HepRepAttDef def1) {
        if (def1 == null) {
            return null;
        }
        return new HepRepAttDefAdapter(def1, AttributeNameTranslator.getName2(def1.getName()), def1.getDescription(), def1.getType(), def1.getExtra());
    }

    public HepRepType createHepRepType(HepRep heprep1, HepRepType parent) {
        return new HepRepTypeFromHepRepAdapter(heprep1, parent);
    }

    public HepRepType createHepRepType(hep.graphics.heprep1.HepRepType type1, HepRepType parent, HepRepInstance instance) {
        return new HepRepTypeFromTypeAdapter(type1, parent, instance);
    }

    public HepRepType createHepRepType(hep.graphics.heprep1.HepRepType type1, hep.graphics.heprep1.HepRepInstance instance1, HepRepType parent, HepRepInstance instance, String suffix) {
        return new HepRepTypeFromInstanceAdapter(type1, instance1, parent, instance, suffix);
    }

    public HepRepInstance createHepRepInstance(HepRep heprep1, HepRepInstance parent, HepRepType type) {
        return new HepRepInstanceFromHepRepAdapter(heprep1, parent, type);
    }

    public HepRepInstance createHepRepInstance(hep.graphics.heprep1.HepRepInstance instance1, HepRepInstance parent, HepRepType type) {
        return new HepRepInstanceFromInstanceAdapter(instance1, parent, type);
    }

    public HepRepInstance createHepRepInstance(hep.graphics.heprep1.HepRepInstance instance1, HepRepPrimitive primitive1, HepRepInstance parent, HepRepType type) {
        return new HepRepInstanceFromPrimitiveAdapter(instance1, primitive1, parent, type);
    }

    public hep.graphics.heprep.HepRepPoint createHepRepPoint(HepRepPoint point1, HepRepInstance parent) {
        return new HepRepPointAdapter(point1, parent);
    }

    static {
        HashMap<String, String> poly = new HashMap<String, String>();
        poly.put("polypoint", "Point");
        poly.put("polyline", "Line");
        HashMap<String, String> fonts = new HashMap<String, String>();
        fonts.put("arial", "SansSerif");
        fonts.put("helvetica", "SansSerif");
        fonts.put("times", "Serif");
        fonts.put("courrier", "MonoSpaced");
        valueTranslator = new HashMap();
        valueTranslator.put("drawas", poly);
        valueTranslator.put("drawasoptions", poly);
        valueTranslator.put("fontname", fonts);
    }
}

