/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.util;

public class HepRepMath {
    private HepRepMath() {
    }

    public static double getX(double x, double xVertex) {
        return x - xVertex;
    }

    public static double getY(double y, double yVertex) {
        return y - yVertex;
    }

    public static double getZ(double z, double zVertex) {
        return z - zVertex;
    }

    public static double getRho(double x, double y, double xVertex, double yVertex) {
        double dx = HepRepMath.getX(x, xVertex);
        double dy = HepRepMath.getY(y, yVertex);
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double getRho(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public static double getPhi(double x, double y, double xVertex, double yVertex) {
        return Math.atan2(HepRepMath.getY(y, yVertex), HepRepMath.getX(x, xVertex));
    }

    public static double getPhi(double x, double y) {
        return Math.atan2(y, x);
    }

    public static double getTheta(double x, double y, double z, double xVertex, double yVertex, double zVertex) {
        return Math.atan2(HepRepMath.getRho(HepRepMath.getX(x, xVertex), HepRepMath.getY(y, yVertex)), HepRepMath.getZ(z, zVertex));
    }

    public static double getTheta(double x, double y, double z) {
        return Math.atan2(HepRepMath.getRho(x, y), z);
    }

    public static double getR(double x, double y, double z, double xVertex, double yVertex, double zVertex) {
        double rho = HepRepMath.getRho(HepRepMath.getX(x, xVertex), HepRepMath.getY(y, yVertex));
        double dz = HepRepMath.getZ(z, zVertex);
        return Math.sqrt(rho * rho + dz * dz);
    }

    public static double getR(double x, double y, double z) {
        double rho = HepRepMath.getRho(x, y);
        return Math.sqrt(rho * rho + z * z);
    }

    public static double getEta(double x, double y, double z, double xVertex, double yVertex, double zVertex) {
        double ct = Math.cos(HepRepMath.getTheta(x, y, z, xVertex, yVertex, zVertex));
        return -0.5 * Math.log((1.0 - ct) / (1.0 + ct));
    }

    public static double getEta(double x, double y, double z) {
        double ct = Math.cos(HepRepMath.getTheta(x, y, z));
        return -0.5 * Math.log((1.0 - ct) / (1.0 + ct));
    }
}

