/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.util;

import java.awt.Color;
import org.freehep.swing.ColorConverter;

public class HepRepColor {
    public static final Color invisible = new Color(255, 255, 255, 0);
    private static final ColorConverter cc = new ColorConverter(){

        @Override
        protected Color createColor(int red, int green, int blue, int alpha) {
            if (red <= 1 && green <= 1 && blue <= 1 && (alpha <= 1 || alpha == 255)) {
                Color c = new Color((float)red, (float)green, (float)blue, alpha == 255 ? 1.0f : (float)alpha);
                return c;
            }
            return super.createColor(red, green, blue, alpha);
        }
    };

    private HepRepColor() {
    }

    public static final Color get(String name) {
        try {
            return cc.stringToColor(name);
        }
        catch (ColorConverter.ColorConversionException x) {
            System.err.println(x.getMessage() + " defaulting to 'white'.");
            return Color.white;
        }
    }

    public static String get(Color color) {
        return cc.colorToString(color);
    }

    static {
        cc.addEntry(invisible, "Invisible");
    }
}

