/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.test;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.HepRepAttributeListener;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepIterator;
import hep.graphics.heprep.util.HepRepIO;
import hep.graphics.heprep.util.HepRepUtil;
import java.awt.Color;
import java.util.ArrayList;

public class TestIterator
implements HepRepAttributeListener {
    public void run(String[] args) throws Throwable {
        ArrayList<String> layers;
        String fname = args[0];
        HepRep hepRep = HepRepIO.readHepRep(fname);
        if (args.length == 1) {
            layers = null;
        } else {
            layers = new ArrayList<String>();
            for (int j = 1; j < args.length; ++j) {
                layers.add(args[j]);
            }
        }
        HepRepIterator it = HepRepUtil.getInstances(hepRep.getInstanceTreeList(), layers, null, false);
        it.addHepRepAttributeListener("Layer", this);
        it.addHepRepAttributeListener("DrawAs", this);
        it.addHepRepAttributeListener("Color", this);
        while (it.hasNext()) {
            HepRepInstance instance = (HepRepInstance)it.next();
            System.out.print("Instance of ");
            System.out.print(instance.getType());
            System.out.print(" as ");
            System.out.println(instance.getAttValue("drawas"));
        }
    }

    @Override
    public void setAttribute(HepRepInstance instance, String key, String value, String lowerCaseValue, int showLabel) {
        if (key.equals("layer")) {
            System.out.println("============================================");
        }
        System.out.println(key + "=" + value + ":" + showLabel);
    }

    @Override
    public void setAttribute(HepRepInstance instance, String key, Color value, int showLabel) {
        System.out.println(key + "=" + value + ":" + showLabel);
    }

    @Override
    public void setAttribute(HepRepInstance instance, String key, long value, int showLabel) {
        System.out.println(key + "=" + value + ":" + showLabel);
    }

    @Override
    public void setAttribute(HepRepInstance instance, String key, int value, int showLabel) {
        System.out.println(key + "=" + value + ":" + showLabel);
    }

    @Override
    public void setAttribute(HepRepInstance instance, String key, double value, int showLabel) {
        System.out.println(key + "=" + value + ":" + showLabel);
    }

    @Override
    public void setAttribute(HepRepInstance instance, String key, boolean value, int showLabel) {
        System.out.println(key + "=" + value + ":" + showLabel);
    }

    @Override
    public void removeAttribute(HepRepInstance instance, String key) {
        System.out.println("*" + key);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: TestIterator filename [layernames]");
            System.exit(1);
        }
        try {
            new TestIterator().run(args);
        }
        catch (Throwable e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }
}

