/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.rmi;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.HepRepAction;
import hep.graphics.heprep.HepRepFactory;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepSelectFilter;
import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.ref.DefaultHepRepFactory;
import hep.graphics.heprep.rmi.RMIHepRep;
import hep.graphics.heprep.util.HashMapList;
import hep.graphics.heprep.util.MapList;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HepRepAdapter
implements HepRep {
    private HepRepFactory factory;
    private RMIHepRep heprep;
    private MapList instanceTrees = new HashMapList();
    private MapList typeTrees = new HashMapList();

    public HepRepAdapter(RMIHepRep heprep) {
        this.heprep = heprep;
        this.factory = new DefaultHepRepFactory();
    }

    @Override
    public HepRep copy() throws CloneNotSupportedException {
        return this.copy(null);
    }

    @Override
    public HepRep copy(HepRepSelectFilter filter) throws CloneNotSupportedException {
        HepRep copy = this.factory.createHepRep();
        Iterator i = this.getLayerOrder().iterator();
        while (i.hasNext()) {
            copy.addLayer((String)i.next());
        }
        for (HepRepTypeTree typeTree : this.getTypeTreeList()) {
            copy.addTypeTree(typeTree.copy());
        }
        for (HepRepInstanceTree instanceTree : this.getInstanceTreeList()) {
            HepRepTreeID typeTreeID = instanceTree.getTypeTree();
            HepRepTypeTree typeTree = copy.getTypeTree(typeTreeID.getName(), typeTreeID.getVersion());
            copy.addInstanceTree(instanceTree.copy(typeTree, filter));
        }
        return copy;
    }

    @Override
    public void addLayer(String layer) {
        throw new RuntimeException("HepRepAdapter.addLayer is not implemented.");
    }

    @Override
    public List getLayerOrder() {
        try {
            return this.heprep.getLayerOrder();
        }
        catch (RemoteException re) {
            return null;
        }
    }

    @Override
    public void addTypeTree(HepRepTypeTree typeTree) {
        if (typeTree == null) {
            return;
        }
        this.typeTrees.put(this.factory.createHepRepTreeID(typeTree.getName(), typeTree.getVersion()), typeTree);
    }

    @Override
    public void removeTypeTree(HepRepTypeTree typeTree) {
        if (typeTree == null) {
            return;
        }
        this.typeTrees.remove(this.factory.createHepRepTreeID(typeTree.getName(), typeTree.getVersion()));
    }

    @Override
    public HepRepTypeTree getTypeTree(String name, String version) {
        try {
            HepRepTypeTree typeTree = (HepRepTypeTree)this.typeTrees.get(this.factory.createHepRepTreeID(name, version));
            if (typeTree == null) {
                typeTree = this.heprep.getTypeTree(name, version);
                this.addTypeTree(typeTree);
            }
            return typeTree;
        }
        catch (RemoteException re) {
            return null;
        }
    }

    @Override
    public Set getTypeTrees() {
        return this.typeTrees.valueSet();
    }

    @Override
    public List getTypeTreeList() {
        return this.typeTrees.valueList();
    }

    @Override
    public void addInstanceTree(HepRepInstanceTree instanceTree) {
        if (instanceTree == null) {
            return;
        }
        this.instanceTrees.put(this.factory.createHepRepTreeID(instanceTree.getName(), instanceTree.getVersion()), instanceTree);
    }

    @Override
    public void overlayInstanceTree(HepRepInstanceTree instanceTree) {
        throw new RuntimeException("HepRepAdapter.overlayInstanceTree is not implemented.");
    }

    @Override
    public void removeInstanceTree(HepRepInstanceTree instanceTree) {
        if (instanceTree == null) {
            return;
        }
        this.instanceTrees.remove(this.factory.createHepRepTreeID(instanceTree.getName(), instanceTree.getVersion()));
    }

    @Override
    public HepRepInstanceTree getInstanceTreeTop(String name, String version) {
        try {
            HepRepInstanceTree instanceTree = (HepRepInstanceTree)this.instanceTrees.get(this.factory.createHepRepTreeID(name, version));
            if (instanceTree == null) {
                instanceTree = this.heprep.getInstanceTreeTop(name, version);
                this.addInstanceTree(instanceTree);
            }
            return instanceTree;
        }
        catch (RemoteException re) {
            return null;
        }
    }

    @Override
    public HepRepInstanceTree getInstances(String name, String version, String[] typeNames) {
        try {
            HepRepInstanceTree instanceTree = (HepRepInstanceTree)this.instanceTrees.get(this.factory.createHepRepTreeID(name, version));
            if (instanceTree == null) {
                instanceTree = this.heprep.getInstances(name, version, typeNames);
                this.addInstanceTree(instanceTree);
            }
            return instanceTree;
        }
        catch (RemoteException re) {
            return null;
        }
    }

    @Override
    public HepRepInstanceTree getInstancesAfterAction(String name, String version, String[] typeNames, HepRepAction[] actions, boolean getPoints, boolean getDrawAtts, boolean getNonDrawAtts, String[] invertAtts) {
        try {
            HepRepInstanceTree instanceTree = this.heprep.getInstancesAfterAction(name, version, typeNames, actions, getPoints, getDrawAtts, getNonDrawAtts, invertAtts);
            this.addInstanceTree(instanceTree);
            return instanceTree;
        }
        catch (RemoteException re) {
            return null;
        }
    }

    @Override
    public String checkForException() {
        return "Not Implemented";
    }

    @Override
    public Set getInstanceTrees() {
        return this.instanceTrees.valueSet();
    }

    @Override
    public List getInstanceTreeList() {
        return this.instanceTrees.valueList();
    }

    public boolean equals(Object o) {
        if (o instanceof HepRep) {
            HepRep ref = (HepRep)o;
            if (!ref.getLayerOrder().equals(this.getLayerOrder())) {
                return false;
            }
            if (!ref.getTypeTreeList().equals(this.getTypeTreeList())) {
                return false;
            }
            return ref.getInstanceTreeList().equals(this.getInstanceTreeList());
        }
        return false;
    }

    public int hashCode() {
        long code = this.getLayerOrder().hashCode();
        code += (long)this.getTypeTreeList().hashCode();
        return (int)(code += (long)this.getInstanceTreeList().hashCode());
    }
}

