/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.ref;

import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.ref.DefaultHepRepTreeID;
import hep.graphics.heprep.ref.DefaultHepRepType;
import hep.graphics.heprep.util.HashMapList;
import hep.graphics.heprep.util.HepRepUtil;
import hep.graphics.heprep.util.MapList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

public class DefaultHepRepTypeTree
extends DefaultHepRepTreeID
implements HepRepTypeTree,
Serializable {
    private MapList types;

    protected DefaultHepRepTypeTree(HepRepTreeID typeTree) {
        super(typeTree.getName(), typeTree.getVersion());
    }

    @Override
    public HepRepTypeTree copy() throws CloneNotSupportedException {
        DefaultHepRepTypeTree copy = new DefaultHepRepTypeTree(this);
        for (HepRepType type : this.getTypeList()) {
            HepRepType typeCopy = type.copy(null);
            copy.addType(typeCopy);
        }
        return copy;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    @Override
    public void addType(HepRepType type) {
        if (this.types == null) {
            this.types = new HashMapList();
        }
        this.types.put(type.getName(), type);
    }

    @Override
    public Set getTypes() {
        return this.types.valueSet();
    }

    @Override
    public List getTypeList() {
        return this.types.valueList();
    }

    @Override
    public HepRepType getType(String fullName) {
        return HepRepUtil.getType(this.types.valueList(), fullName);
    }

    @Override
    public String toString() {
        return "HepRepTypeTree: " + this.getQualifier() + ":" + this.getName() + ":" + this.getVersion();
    }

    public void display(String indent) {
        System.out.println(indent + this.toString());
        for (DefaultHepRepType type : this.getTypeList()) {
            type.display(indent + "  ");
        }
    }
}

