/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.ref;

import hep.graphics.heprep.HepRepAttValue;
import hep.graphics.heprep.HepRepAttributeListener;
import hep.graphics.heprep.HepRepFrameListener;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DefaultHepRepIterator
implements HepRepIterator {
    private List instanceTrees;
    private Iterator treeIterator;
    private HepRepInstanceTree currentTree;
    private Iterator layerIterator;
    private String currentLayer;
    private boolean iterateFrames;
    private boolean inFrameLayer;
    private boolean inFrameLayerChanged;
    private Set types = null;
    private HepRepInstance nextInstance = null;
    private HepRepInstance currentInstance = null;
    private HepRepInstance[] instanceStack = new HepRepInstance[1000];
    private int instanceStackTop = -1;
    private Map attListeners;
    private List frameListeners;
    private Map attributes;

    public DefaultHepRepIterator(List instanceTrees) {
        this(instanceTrees, null);
    }

    public DefaultHepRepIterator(List instanceTrees, List layers) {
        this(instanceTrees, layers, false);
    }

    public DefaultHepRepIterator(List instanceTrees, List layers, boolean iterateFrames) {
        this(instanceTrees, layers, null, iterateFrames);
    }

    public DefaultHepRepIterator(List instanceTrees, List layers, Set types, boolean iterateFrames) {
        if (layers == null || layers.size() == 0) {
            layers = new ArrayList();
            layers.add(null);
        }
        this.layerIterator = layers.iterator();
        this.currentLayer = (String)this.layerIterator.next();
        if (this.currentLayer != null) {
            this.currentLayer = this.currentLayer.intern();
        }
        this.types = types;
        this.instanceTrees = instanceTrees;
        this.treeIterator = instanceTrees.iterator();
        this.currentTree = null;
        this.iterateFrames = iterateFrames;
        this.inFrameLayer = false;
        this.inFrameLayerChanged = true;
        this.attListeners = new HashMap();
        this.frameListeners = new ArrayList();
        this.attributes = new HashMap();
    }

    private void fillInstanceStack(Collection instances) {
        Iterator iterator = instances.iterator();
        while (iterator.hasNext()) {
            ++this.instanceStackTop;
            if (this.instanceStackTop >= this.instanceStack.length) {
                HepRepInstance[] oldInstanceStack = this.instanceStack;
                int newCapacity = oldInstanceStack.length * 3 / 2 + 1;
                this.instanceStack = new HepRepInstance[newCapacity];
                System.arraycopy(oldInstanceStack, 0, this.instanceStack, 0, oldInstanceStack.length);
            }
            this.instanceStack[this.instanceStackTop] = (HepRepInstance)iterator.next();
        }
    }

    @Override
    public void addHepRepAttributeListener(String name, HepRepAttributeListener listener) {
        String lowerCaseName = name != null ? name.toLowerCase().intern() : name;
        ArrayList<HepRepAttributeListener> list = (ArrayList<HepRepAttributeListener>)this.attListeners.get(lowerCaseName);
        if (list == null) {
            list = new ArrayList<HepRepAttributeListener>();
            this.attListeners.put(lowerCaseName, list);
        }
        list.add(listener);
    }

    @Override
    public void removeHepRepAttributeListener(String name, HepRepAttributeListener listener) {
        String lowerCaseName = name != null ? name.toLowerCase() : null;
        List list = (List)this.attListeners.get(lowerCaseName);
        if (list != null) {
            list.remove(listener);
            if (list.isEmpty()) {
                this.attListeners.remove(lowerCaseName);
            }
        }
    }

    @Override
    public void addHepRepFrameListener(HepRepFrameListener l) {
        this.frameListeners.add(l);
    }

    @Override
    public void removeHepRepFrameListener(HepRepFrameListener l) {
        this.frameListeners.remove(l);
    }

    private void informFrameListeners() {
        if (this.inFrameLayerChanged) {
            this.inFrameLayerChanged = false;
            for (HepRepFrameListener l : this.frameListeners) {
                l.setFrameLayer(this.inFrameLayer);
            }
        }
    }

    private void informAttributeListeners() {
        for (String lowerCaseName : this.attListeners.keySet()) {
            List list = (List)this.attListeners.get(lowerCaseName);
            if (list == null) continue;
            for (HepRepAttributeListener listener : list) {
                if (listener == null) continue;
                if (lowerCaseName == null) {
                    this.informAttributeListener(listener);
                    continue;
                }
                this.informAttributeListener(lowerCaseName, listener);
            }
        }
    }

    private void informAttributeListener(HepRepAttributeListener listener) {
        Iterator i;
        HashSet<String> attNames = new HashSet<String>();
        if (this.currentInstance != null) {
            i = this.currentInstance.getAttValuesFromNode().iterator();
            while (i.hasNext()) {
                attNames.add(((HepRepAttValue)i.next()).getLowerCaseName());
            }
        }
        i = this.nextInstance.getAttValuesFromNode().iterator();
        while (i.hasNext()) {
            attNames.add(((HepRepAttValue)i.next()).getLowerCaseName());
        }
        i = attNames.iterator();
        while (i.hasNext()) {
            this.informAttributeListener((String)i.next(), listener);
        }
    }

    private void informAttributeListener(String lowerCaseName, HepRepAttributeListener listener) {
        HepRepAttValue nextAttValue = null;
        if (this.currentInstance != null) {
            nextAttValue = this.nextInstance.getAttValueFromNode(lowerCaseName);
            if (nextAttValue == null) {
                if (this.currentInstance.getAttValueFromNode(lowerCaseName) == null && this.currentInstance.getType() == this.nextInstance.getType()) {
                    return;
                }
                nextAttValue = this.nextInstance.getAttValue(lowerCaseName);
            }
        } else {
            nextAttValue = this.nextInstance.getAttValue(lowerCaseName);
        }
        this.informAttributeListener(lowerCaseName, listener, nextAttValue);
    }

    private void informAttributeListener(String lowerCaseName, HepRepAttributeListener listener, HepRepAttValue attValue) {
        Object oldAttValue = this.attributes.get(lowerCaseName);
        if (oldAttValue == attValue) {
            return;
        }
        if (attValue != null && attValue.equals(oldAttValue)) {
            return;
        }
        this.attributes.put(lowerCaseName, attValue);
        if (attValue == null) {
            listener.removeAttribute(this.nextInstance, lowerCaseName);
            return;
        }
        switch (attValue.getType()) {
            case 1: {
                listener.setAttribute(this.nextInstance, lowerCaseName, attValue.getString(), attValue.getLowerCaseString(), attValue.showLabel());
                break;
            }
            case 2: {
                listener.setAttribute(this.nextInstance, lowerCaseName, attValue.getColor(), attValue.showLabel());
                break;
            }
            case 10: {
                listener.setAttribute(this.nextInstance, lowerCaseName, attValue.getLong(), attValue.showLabel());
                break;
            }
            case 11: {
                listener.setAttribute(this.nextInstance, lowerCaseName, attValue.getInteger(), attValue.showLabel());
                break;
            }
            case 20: {
                listener.setAttribute(this.nextInstance, lowerCaseName, attValue.getDouble(), attValue.showLabel());
                break;
            }
            case 30: {
                listener.setAttribute(this.nextInstance, lowerCaseName, attValue.getBoolean(), attValue.showLabel());
                break;
            }
            default: {
                System.err.println("Unknown type in DefaultHepRepIterator: '" + attValue.getType() + "'");
                listener.setAttribute(this.nextInstance, lowerCaseName, attValue.toString(), attValue.toString().toLowerCase(), attValue.showLabel());
            }
        }
    }

    @Override
    public HepRepInstance nextInstance() {
        return (HepRepInstance)this.next();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.informFrameListeners();
        this.informAttributeListeners();
        this.currentInstance = this.nextInstance;
        this.nextInstance = null;
        return this.currentInstance;
    }

    @Override
    public boolean hasNext() {
        if (this.nextInstance != null) {
            return true;
        }
        do {
            if (this.instanceStackTop < 0) {
                if (this.treeIterator.hasNext()) {
                    this.currentTree = (HepRepInstanceTree)this.treeIterator.next();
                } else if (this.inFrameLayer) {
                    this.inFrameLayer = false;
                    this.inFrameLayerChanged = true;
                    this.treeIterator = this.instanceTrees.iterator();
                    this.currentTree = (HepRepInstanceTree)this.treeIterator.next();
                } else {
                    if (!this.layerIterator.hasNext()) {
                        this.nextInstance = null;
                        return false;
                    }
                    this.currentLayer = (String)this.layerIterator.next();
                    if (this.currentLayer != null) {
                        this.currentLayer = this.currentLayer.intern();
                    }
                    this.treeIterator = this.instanceTrees.iterator();
                    this.currentTree = (HepRepInstanceTree)this.treeIterator.next();
                    if (this.iterateFrames) {
                        this.inFrameLayer = true;
                        this.inFrameLayerChanged = true;
                    }
                }
                this.fillInstanceStack(this.currentTree.getInstances());
            }
            this.nextInstance = this.instanceStack[this.instanceStackTop];
            --this.instanceStackTop;
            this.fillInstanceStack(this.nextInstance.getInstances());
        } while (this.currentLayer != null && this.nextInstance.getLayer() != this.currentLayer || this.types != null && !this.types.contains(this.nextInstance.getType()) || this.iterateFrames && this.inFrameLayer && !this.nextInstance.hasFrame());
        return true;
    }

    @Override
    public boolean drawAsFrame() {
        return this.inFrameLayer;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

