/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.corba;

import hep.graphics.heprep.HepRepAttribute;
import hep.graphics.heprep.corba.HepRepAttValueAdapter;
import hep.graphics.heprep.corba.idl.HepRepAttValue;
import hep.graphics.heprep.ref.DefaultHepRepAttValue;
import hep.graphics.heprep.util.ValueSet;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public abstract class CORBAHepRepAttribute
implements HepRepAttribute {
    private Map atts;

    private void fillAtts() {
        if (this.atts == null) {
            this.atts = new Hashtable();
            int n = this.getAttValues().length;
            for (int i = 0; i < n; ++i) {
                HepRepAttValueAdapter value = new HepRepAttValueAdapter(this.getAttValues()[i]);
                this.atts.put(value.getLowerCaseName(), value);
            }
        }
    }

    @Override
    public Set getAttValuesFromNode() {
        this.fillAtts();
        return new ValueSet(this.atts);
    }

    @Override
    public hep.graphics.heprep.HepRepAttValue getAttValueFromNode(String lowerCaseName) {
        lowerCaseName = lowerCaseName.intern();
        this.fillAtts();
        return (hep.graphics.heprep.HepRepAttValue)this.atts.get(lowerCaseName);
    }

    @Override
    public void addAttValue(String key, String value) {
        this.addAttValue(key, value, 0);
    }

    @Override
    public void addAttValue(String key, int value) {
        this.addAttValue(key, value, 0);
    }

    @Override
    public void addAttValue(String key, long value) {
        this.addAttValue(key, value, 0);
    }

    @Override
    public void addAttValue(String key, double value) {
        this.addAttValue(key, value, 0);
    }

    @Override
    public void addAttValue(String key, boolean value) {
        this.addAttValue(key, value, 0);
    }

    @Override
    public void addAttValue(String key, Color value) {
        this.addAttValue(key, value, 0);
    }

    @Override
    public void addAttValue(String key, String value, int showLabel) {
        this.addAttValue(new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addAttValue(String key, int value, int showLabel) {
        this.addAttValue(new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addAttValue(String key, long value, int showLabel) {
        this.addAttValue(new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addAttValue(String key, double value, int showLabel) {
        this.addAttValue(new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addAttValue(String key, boolean value, int showLabel) {
        this.addAttValue(new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addAttValue(String key, Color value, int showLabel) {
        this.addAttValue(new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addAttValue(hep.graphics.heprep.HepRepAttValue attValue) {
        this.fillAtts();
        this.atts.put(attValue.getLowerCaseName(), attValue);
    }

    @Override
    public hep.graphics.heprep.HepRepAttValue removeAttValue(String key) {
        if (this.atts == null) {
            return null;
        }
        return (hep.graphics.heprep.HepRepAttValue)this.atts.remove(key.toLowerCase());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HepRepAttribute) {
            HepRepAttribute att = (HepRepAttribute)o;
            hep.graphics.heprep.HepRepAttValue layer = this.getAttValueFromNode("layer");
            hep.graphics.heprep.HepRepAttValue attLayer = att.getAttValueFromNode("layer");
            if (layer != null ? !layer.equals(attLayer) : attLayer != null) {
                return false;
            }
            return att.getAttValuesFromNode().equals(this.getAttValuesFromNode());
        }
        return false;
    }

    public int hashCode() {
        long code = 0L;
        hep.graphics.heprep.HepRepAttValue layer = this.getAttValueFromNode("layer");
        if (layer != null) {
            code += (long)layer.hashCode();
        }
        return (int)(code += (long)this.getAttValuesFromNode().hashCode());
    }

    protected abstract HepRepAttValue[] getAttValues();
}

