/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.test.jaida;

import hep.aida.IAnalysisFactory;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.dev.IDevTree;
import hep.aida.dev.IOnDemandStore;
import hep.aida.dev.IStore;
import hep.aida.dev.IStoreFactory;
import hep.aida.ref.tree.TreeObjectAlreadyExistException;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.freehep.util.FreeHEPLookup;

public class TestOnDemandStore
extends TestCase {
    private ITree tree;
    private IStoreFactory storeFactory;
    private static final int MAX_DEPTH = 4;
    private static final int DIR_SIZE = 4;

    public TestOnDemandStore(String name) {
        super(name);
    }

    public void testGoodPath() {
        IManagedObject obj = this.tree.find("f0/f1/f2/f3/1");
        TestOnDemandStore.assertTrue((boolean)(obj instanceof MyObject));
    }

    public void testBadPath() {
        try {
            IManagedObject obj = this.tree.find("f0/f1/f6/f3/1");
            TestOnDemandStore.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAcrossMountPoint() throws Exception {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree top = af.createTreeFactory().create();
        top.mount("x", this.tree, "/");
        IManagedObject obj = top.find("/x/f3/f2/f1/f0/3");
        TestOnDemandStore.assertTrue((boolean)(obj instanceof MyObject));
        top.close();
    }

    public void testLS() {
        String[] names = this.tree.listObjectNames("/", true);
        int nNodes = 0;
        int nFolders = 1;
        for (int level = 0; level <= 4; ++level) {
            nNodes += nFolders * (level == 4 ? 4 : 8);
            nFolders *= 4;
        }
        TestOnDemandStore.assertEquals((int)nNodes, (int)names.length);
    }

    protected void tearDown() throws Exception {
        this.tree.close();
        FreeHEPLookup.instance().remove(this.storeFactory);
        super.tearDown();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.storeFactory = new MyStoreFactory();
        FreeHEPLookup.instance().add(this.storeFactory);
        IAnalysisFactory af = IAnalysisFactory.create();
        this.tree = af.createTreeFactory().create("Test Store", "test");
    }

    public static void main(String[] args) {
        TestOnDemandStore test = new TestOnDemandStore("Test IOnDemandStore");
        try {
            test.setUp();
            test.testGoodPath();
            test.testAcrossMountPoint();
            System.out.println("\nRoot directory:");
            test.tree.ls("/");
            System.out.println("\nDirectory: /f1");
            test.tree.ls("/f1");
            System.out.println("\nDirectory: /f1/f3/f1");
            test.tree.ls("/f1/f3/f1");
            System.out.println("\nDirectory: /f2/f3/f1");
            test.tree.ls("/f2/f3/f1");
            System.out.println("\nDirectory: /f3/f2/f1/f0");
            test.tree.ls("/f3/f2/f1/f0");
            test.tearDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class MyObject
    implements IManagedObject {
        private int index;

        MyObject(int i) {
            this.index = i;
        }

        public String name() {
            return String.valueOf(this.index);
        }

        public String type() {
            return "myType";
        }
    }

    private class MyOnDemandStore
    implements IOnDemandStore {
        private MyOnDemandStore() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void commit(IDevTree tree, Map options) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void read(IDevTree tree, String path) throws IllegalArgumentException, IOException {
            StringTokenizer st = new StringTokenizer(path, "/");
            int depth = st.countTokens();
            if (depth > 4) {
                throw new IllegalArgumentException("Bad path: " + path);
            }
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.charAt(0) != 'f') {
                    throw new IllegalArgumentException("Bad path: " + path);
                }
                char n = token.charAt(1);
                if (n >= '0' && n <= '3') continue;
                throw new IllegalArgumentException("Bad path: " + path);
            }
            this.createDummyFolder(tree, path, depth < 4);
            tree.hasBeenFilled(path);
        }

        @Override
        public void read(IDevTree tree, Map options, boolean readOnly, boolean createNew) throws IOException {
            this.createDummyFolder(tree, "/", true);
            tree.hasBeenFilled("/");
        }

        private void createDummyFolder(IDevTree tree, String path, boolean withSubFolders) {
            int i;
            for (i = 0; i < 4; ++i) {
                tree.add(path, new MyObject(i));
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (withSubFolders) {
                for (i = 0; i < 4; ++i) {
                    try {
                        tree.mkdirs(path + "f" + i);
                        continue;
                    }
                    catch (TreeObjectAlreadyExistException toe) {
                        System.out.println("WARNING: " + toe.getMessage());
                    }
                }
            }
        }
    }

    private class MyStoreFactory
    implements IStoreFactory {
        private MyStoreFactory() {
        }

        @Override
        public IStore createStore() {
            return new MyOnDemandStore();
        }

        @Override
        public String description() {
            return "Test Store";
        }

        @Override
        public boolean supportsType(String type) {
            return "test".equals(type);
        }
    }
}

