/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IManagedObject;
import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.remote.RemoteMutableStore;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Logger;

public abstract class RemoteManagedObject
extends ManagedObject
implements IsObservable {
    public static int DEFAULT_INT = 0;
    public static long DEFAULT_LONG = 0L;
    public static float DEFAULT_FLOAT = 0.0f;
    public static double DEFAULT_DOUBLE = 0.0;
    public static double rmsFactor = Math.sqrt(12.0);
    protected IDevMutableStore store = null;
    protected String treePath = null;
    protected String aidaType = "IManagedObject";
    protected boolean dataIsValid = false;
    protected boolean stateDidChange = false;
    protected Logger remoteLogger = Logger.getLogger("hep.aida.ref.remote");

    public RemoteManagedObject(String name) {
        super(name);
        this.fillable = false;
    }

    static String getCurrentTime() {
        long millis = System.currentTimeMillis();
        long ml = millis % 1000L;
        Date date = new Date(millis);
        String tmp = DateFormat.getDateTimeInstance().format(date);
        tmp = tmp + " [" + ml + "] :: ";
        return tmp;
    }

    protected void makeSureDataIsValid() {
        if (this.dataIsValid || this.fillable || !this.isConnected) {
            return;
        }
        if (this.store instanceof RemoteMutableStore) {
            ((RemoteMutableStore)this.store).handleDataUpdate((IManagedObject)this, this.treePath, this.aidaType);
        } else if (this.store != null) {
            this.store.updateData(this.treePath, this.aidaType);
        }
    }

    @Override
    public String type() {
        if (this.aidaType != null && !this.aidaType.trim().equals("")) {
            return this.aidaType;
        }
        return super.type();
    }

    public void setStore(IDevMutableStore store) {
        this.store = store;
    }

    public IDevMutableStore getStore() {
        return this.store;
    }

    public void setTreeFolder(String treeFolder) {
        String histName;
        String string = histName = this.name() == null ? "Unknown" : this.name();
        if (histName.startsWith("/")) {
            histName = histName.substring(1);
            histName = AidaUtils.modifyName(histName);
            histName = "/" + histName;
        } else {
            histName = AidaUtils.modifyName(histName);
        }
        if (treeFolder.endsWith("//")) {
            treeFolder = treeFolder.substring(0, treeFolder.length() - 2);
        }
        if (!treeFolder.startsWith("/")) {
            treeFolder = "/" + treeFolder;
        } else if (treeFolder.startsWith("//")) {
            treeFolder = treeFolder.substring(1);
        }
        this.treePath = treeFolder.equals("/") && histName.startsWith("/") ? histName : (treeFolder.endsWith("/") && histName.startsWith("/") ? treeFolder + histName.substring(1) : (treeFolder.endsWith("/") || histName.startsWith("/") ? treeFolder + histName : treeFolder + "/" + histName));
    }

    public String getTreePath() {
        return this.treePath;
    }

    @Override
    public void setConnected(boolean connected) {
        super.setConnected(connected);
        this.setDataValid(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataValid(boolean dataIsValid) {
        boolean fireEvent = false;
        RemoteManagedObject remoteManagedObject = this;
        synchronized (remoteManagedObject) {
            this.remoteLogger.finest("RemoteManagedObject.setDataValid :: DATA: new=" + dataIsValid + ", old=" + this.dataIsValid + ", isValid=" + this.isValid + ", stateDidChange=" + this.stateDidChange + ", path=" + this.treePath);
            if (this.dataIsValid != dataIsValid) {
                this.dataIsValid = dataIsValid;
                if (this.isValid) {
                    fireEvent = true;
                    this.stateDidChange = false;
                } else {
                    this.stateDidChange = true;
                }
            }
        }
        if (fireEvent) {
            this.fireStateChanged();
        }
    }

    public boolean isDataValid() {
        return this.dataIsValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValid(AIDAListener l) {
        boolean fireEvent = false;
        RemoteManagedObject remoteManagedObject = this;
        synchronized (remoteManagedObject) {
            this.remoteLogger.finest("RemoteManagedObject.setValid :: dataIsValid=" + this.dataIsValid + ", oldIsValid=" + this.isValid + ", stateDidChange=" + this.stateDidChange + ", for path=" + this.getTreePath() + ",  AIDAListener: " + l);
            if (this.stateDidChange) {
                fireEvent = true;
                this.stateDidChange = false;
            }
        }
        super.setValid(l);
        if (fireEvent) {
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValidForAll() {
        boolean fireEvent = false;
        RemoteManagedObject remoteManagedObject = this;
        synchronized (remoteManagedObject) {
            this.remoteLogger.finest("RemoteManagedObject.setValidForAll :: dataIsValid=" + this.dataIsValid + ", oldIsValid=" + this.isValid + ", stateDidChange=" + this.stateDidChange + ", for path=" + this.getTreePath());
            if (this.stateDidChange) {
                fireEvent = true;
                this.stateDidChange = false;
            }
        }
        super.setValidForAll();
        if (fireEvent) {
            this.fireStateChanged();
        }
    }
}

