/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IProfile;
import hep.aida.IProfile1D;
import hep.aida.ref.plotter.adapter.AIDAProfileAdapter;
import hep.aida.ref.plotter.adapter.AIDAProfileStatistics1D;
import jas.hist.HasStatistics;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;

public class AIDAProfileAdapter1D
extends AIDAProfileAdapter
implements Rebinnable1DHistogramData,
HasStatistics {
    protected IProfile1D profile;

    AIDAProfileAdapter1D(IProfile1D profile) {
        super((IProfile)profile);
        this.profile = profile;
        String tmp = null;
        try {
            tmp = profile.annotation().value("xAxisType");
            if (tmp != null && tmp.equalsIgnoreCase("date")) {
                this.xAxisType = 3;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        this.setValid();
        double[][] data = new double[2][this.profile.axis().bins()];
        for (int i = 0; i < this.profile.axis().bins(); ++i) {
            data[0][i] = this.profile.binHeight(i);
            if (Double.isInfinite(data[0][i])) {
                data[0][i] = Double.NaN;
            }
            data[1][i] = this.errorMode() == USE_ERROR_ON_MEAN ? this.profile.binError(i) : this.profile.binRms(i);
        }
        return data;
    }

    public double getMin() {
        return this.profile.axis().lowerEdge();
    }

    public double getMax() {
        return this.profile.axis().upperEdge();
    }

    public int getBins() {
        return this.profile.axis().bins();
    }

    public boolean isRebinnable() {
        return false;
    }

    public int getAxisType() {
        return this.xAxisType;
    }

    public void setAxisType(int type) {
        this.xAxisType = type;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.profile.title();
    }

    public Statistics getStatistics() {
        return new AIDAProfileStatistics1D(this.profile);
    }
}

