/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.optimizer.jminuit;

import hep.aida.ref.optimizer.AbstractOptimizerConfiguration;

class JMinuitConfiguration
extends AbstractOptimizerConfiguration {
    public static final int LOW_CALL_STRATEGY = 0;
    public static final int MEDIUM_CALL_STRATEGY = 1;
    public static final int HIGH_CALL_STRATEGY = 2;
    public static final String IMPROVE = "IMP";
    public static final String MIGRAD = "MIG";
    public static final String MINIMIZE = "MINI";
    public static final String SIMPLEX = "SIMP";
    public static final String SEEK = "SEE";
    private double errorDefinition = 1.0;
    private int errorDefinitionInt = 0;

    JMinuitConfiguration() {
        this.setTolerance(1.0E-5);
        this.setMaxIterations(0);
        this.setPrintLevel(-1);
        this.setErrorDefinition(0);
        this.setStrategy(1);
        this.setMethod(MIGRAD);
    }

    @Override
    public void setErrorDefinition(int errorDefinition) {
        switch (errorDefinition) {
            case 0: 
            case 1: {
                this.errorDefinition = 1.0;
                this.errorDefinitionInt = errorDefinition;
                break;
            }
            case 2: {
                this.errorDefinition = 0.5;
                this.errorDefinitionInt = errorDefinition;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported error definition" + errorDefinition);
            }
        }
    }

    @Override
    public int errorDefinition() {
        return this.errorDefinitionInt;
    }

    public double errorDef() {
        return this.errorDefinition;
    }

    @Override
    public void setMethod(String method) {
        method.toUpperCase();
        if (!(method.startsWith(IMPROVE) || method.startsWith(MIGRAD) || method.startsWith(SIMPLEX) || method.startsWith(MINIMIZE) || method.startsWith(SEEK))) {
            throw new IllegalArgumentException("Unsupported method : " + method);
        }
        super.setMethod(method);
    }

    @Override
    public void setPrecision(double precision) {
        super.setPrecision(precision);
    }

    @Override
    public void setStrategy(int strategy) {
        switch (strategy) {
            case 0: 
            case 1: 
            case 2: {
                super.setStrategy(strategy);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported strategy : " + strategy);
            }
        }
    }

    @Override
    public void setUseFunctionHessian(boolean useHessian) {
        throw new UnsupportedOperationException();
    }
}

