/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SliderUI;

public class GJDial
extends JSlider
implements MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private static final String uiClassID = "BasicGJDialUI";
    private Paint BackgroundFill = null;
    private Paint Fill = Color.white;
    private Color LineColor = Color.gray;
    private JLabel label = new JLabel();
    private boolean displayValue = false;
    private int mouseX;
    private int mouseY;
    private double Theta = 0.0;
    private double ThetaAtDragStart;
    private double MouseThetaAtDragStart;
    private static final float DialLineWidth = 2.5f;
    private static final BasicStroke pen1 = new BasicStroke(2.5f, 1, 2);
    private static final BasicStroke pen2 = new BasicStroke(1.25f, 1, 2);
    private static NumberFormat nf = NumberFormat.getInstance();
    private GJRoundedBoundedDataModel model = new GJRoundedBoundedDataModel();
    private ActionListener actionListener = null;

    public GJDial() {
        this(100, 1, false);
    }

    public GJDial(int diameter, int n) {
        this(diameter, n, false);
    }

    public GJDial(int diameter, int n, boolean flag) {
        this.setup();
        this.model.setAvailableTurns(n);
        this.displayValue = flag;
        this.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        super.setModel(this.model);
        super.setOpaque(false);
        this.setPreferredSize(new Dimension(diameter, diameter));
        this.updateUI();
    }

    private void setup() {
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        layout.putConstraint("HorizontalCenter", (Component)this.label, 0, "HorizontalCenter", (Component)this);
        layout.putConstraint("VerticalCenter", (Component)this.label, 0, "VerticalCenter", (Component)this);
        this.label.setHorizontalAlignment(0);
        this.add(this.label);
        this.revalidate();
        this.setMajorTickSpacing(20);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setValue(this.getMinimum());
    }

    public void addActionListener(ActionListener listener) {
        this.actionListener = listener;
    }

    @Override
    public void setMinimum(int val) {
        super.setMinimum(val);
        this.repaint();
    }

    @Override
    public void setMaximum(int val) {
        super.setMaximum(val);
        this.repaint();
    }

    @Override
    public int getValue() {
        return this.getValue(this.getTheta());
    }

    private int getValue(double theta) {
        double perTurn = (this.getMaximum() - this.getMinimum()) / this.model.getAvailableTurns();
        double val = (double)this.getMinimum() + (double)this.model.getTurnCount() * perTurn + this.getFraction(theta);
        return (int)val;
    }

    @Override
    public void setValue(int val) {
        int old = this.getValue();
        double perTurn = (this.getMaximum() - this.getMinimum()) / this.model.getAvailableTurns();
        this.model.setTurnCount((int)Math.max(0.0, Math.floor((double)(val -= this.getMinimum()) / perTurn)));
        this.setTheta(Math.PI * 2 - (double)val % perTurn / perTurn * Math.PI * 2.0);
        this.firePropertyChange("value", old, this.getValue());
    }

    private double getFraction(double theta) {
        double perTurn = (this.getMaximum() - this.getMinimum()) / this.model.getAvailableTurns();
        return perTurn - perTurn * theta / Math.PI / 2.0;
    }

    @Override
    public BasicGJDialUI getUI() {
        return (BasicGJDialUI)super.getUI();
    }

    @Override
    public final void updateUI() {
        this.setUI(BasicGJDialUI.createUI(this));
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public Paint getFill() {
        return this.Fill;
    }

    public void setFill(Paint p) {
        this.Fill = p;
    }

    public double getTheta() {
        return this.Theta;
    }

    private void setTheta(double theta) {
        this.Theta = theta;
        this.fireStateChanged();
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "theta"));
        }
        this.repaint();
    }

    private double getThetaAtDragStart() {
        return this.ThetaAtDragStart;
    }

    private void setThetaAtDragStart(double theta) {
        this.ThetaAtDragStart = theta;
    }

    private double getMouseThetaAtDragStart() {
        return this.MouseThetaAtDragStart;
    }

    private void setMouseThetaAtDragStart(double theta) {
        this.MouseThetaAtDragStart = theta;
    }

    public int getTurnCount() {
        return this.model.getTurnCount();
    }

    private void setTurnCount(int val) {
        this.model.setTurnCount(val);
    }

    public void setText(String str) {
        this.label.setText(str);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setDisplayValue(boolean flag) {
        this.displayValue = flag;
    }

    public boolean isDisplayValue() {
        return this.displayValue;
    }

    private void paintBackground(Graphics2D g2d) {
        if (this.isOpaque()) {
            if (this.BackgroundFill == null) {
                this.getUI().update(g2d, this);
            } else {
                g2d.setPaint(this.BackgroundFill);
                g2d.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            }
        }
    }

    private void paintTicks(Graphics2D g2d) {
        if (this.getPaintTicks()) {
            int k;
            Graphics2D g2d2 = (Graphics2D)g2d.create();
            float radius = Math.min(this.getWidth(), this.getHeight()) / 2;
            radius -= 0.1f * radius;
            int xoffset = this.getWidth() / 2;
            int yoffset = this.getHeight() / 2;
            g2d2.setColor(this.getLineColor());
            g2d2.setStroke(pen1);
            for (k = 0; k <= this.getMajorTickSpacing(); ++k) {
                g2d2.drawLine(xoffset, yoffset, (int)((float)xoffset + radius + Math.max(5.0f, radius / 15.0f)), yoffset);
                g2d2.rotate(Math.PI * 2 / (double)this.getMajorTickSpacing(), xoffset, yoffset);
            }
            g2d2.setStroke(pen2);
            for (k = 0; k <= this.getMinorTickSpacing(); ++k) {
                g2d2.drawLine(xoffset, yoffset, (int)((double)((float)xoffset + radius) + Math.max(2.5, (double)(radius / 20.0f))), yoffset);
                g2d2.rotate(Math.PI * 2 / (double)this.getMinorTickSpacing(), xoffset, yoffset);
            }
            g2d2.dispose();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        this.paintBackground(g2d);
        this.paintTicks(g2d);
        g2d.setColor(this.getLineColor());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(pen1);
        float diam = Math.min(this.getWidth(), this.getHeight());
        diam -= 0.1f * diam;
        float xoffset = ((float)this.getWidth() - diam) / 2.0f;
        float yoffset = ((float)this.getHeight() - diam) / 2.0f;
        Ellipse2D.Float circle = new Ellipse2D.Float(xoffset, yoffset, diam, diam);
        g2d.setColor(this.getLineColor());
        g2d.draw(circle);
        g2d.setPaint(this.Fill);
        g2d.fill(circle);
        g2d.setColor(this.getLineColor());
        if (this.displayValue) {
            FontMetrics metrics = g2d.getFontMetrics();
            String str = nf.format(this.getValue());
            g2d.drawString(str, this.getWidth() / 2 - metrics.stringWidth(str) / 2, this.getHeight() / 2 + metrics.getHeight() / 2);
        }
        Ellipse2D.Float circle2 = new Ellipse2D.Float(xoffset + diam - diam / 5.0f, yoffset + diam / 2.0f - diam / 15.0f, diam / 7.5f, diam / 7.5f);
        g2d.rotate(-this.Theta, xoffset + diam / 2.0f, yoffset + diam / 2.0f);
        g2d.draw(circle2);
        g2d.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.mouseX = me.getX();
        this.mouseY = me.getY();
        this.setThetaAtDragStart(this.getTheta());
        this.setMouseThetaAtDragStart(this.getTheta());
        this.mouseDragged(me);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.mouseX = me.getX();
        this.mouseY = me.getY();
        double theta = this.mouseTheta(this.mouseX, this.mouseY);
        this.setMouseThetaAtDragStart(theta);
        this.setThetaAtDragStart(this.getTheta());
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseDragged(MouseEvent me) {
        double oldTheta = this.getTheta();
        this.mouseX = me.getX();
        this.mouseY = me.getY();
        double thisTheta = this.mouseTheta(this.mouseX, this.mouseY);
        if (oldTheta == thisTheta) {
            return;
        }
        double thisArc = this.getMouseThetaAtDragStart() - thisTheta;
        double newTheta = GJDial.arclength(this.getThetaAtDragStart(), thisArc);
        double sz = oldTheta - newTheta;
        boolean normallyClockWise = sz > 0.0;
        int zeroCrossing = 0;
        if (normallyClockWise && oldTheta > 4.71238898038469 && newTheta < 1.5707963267948966) {
            zeroCrossing = -1;
        } else if (!normallyClockWise && oldTheta < 1.5707963267948966 && newTheta > 4.71238898038469) {
            zeroCrossing = 1;
        }
        if (zeroCrossing == -1) {
            if (this.getTurnCount() <= 0) return;
            this.setTurnCount(this.getTurnCount() - 1);
        } else if (zeroCrossing == 1) {
            if (this.getTurnCount() + 1 >= this.model.getAvailableTurns()) return;
            this.setTurnCount(this.getTurnCount() + 1);
        }
        if (newTheta < 0.0) {
            newTheta = 0.0;
        }
        if (newTheta > Math.PI * 2) {
            newTheta = Math.PI * 2;
        }
        this.setTheta(newTheta);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    private static double arclength(double theta1, double theta2) {
        double val = theta1 - theta2;
        if (val > Math.PI * 2 || val < 0.0) {
            val %= Math.PI * 2;
        }
        return val;
    }

    private double mouseTheta(double x, double y) {
        y = (double)this.getHeight() - y - (double)(this.getHeight() / 2);
        return GJDial.getTheta2PI(x -= (double)(this.getWidth() / 2), y);
    }

    private static double getTheta2PI(double x, double y) {
        double sintheta = y / Math.hypot(x, y);
        double theta = Math.asin(sintheta);
        if (x <= 0.0 && y >= 0.0) {
            theta = Math.PI - theta;
        } else if (x <= 0.0 && y <= 0.0) {
            theta = Math.PI - theta;
        } else if (x >= 0.0 && y <= 0.0) {
            theta = Math.PI * 2 + theta;
        }
        return theta;
    }

    public Color getLineColor() {
        return this.LineColor;
    }

    public void setLineColor(Color LineColor) {
        this.LineColor = LineColor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public static class BasicGJDialUI
    extends SliderUI {
        public static ComponentUI createUI(JComponent c) {
            return new BasicGJDialUI();
        }
    }

    private class GJRoundedBoundedDataModel
    extends DefaultBoundedRangeModel {
        private int availableTurns = 1;
        private int turnCount = 0;

        public int getAvailableTurns() {
            return this.availableTurns;
        }

        public void setAvailableTurns(int t) {
            this.availableTurns = t;
        }

        public int getTurnCount() {
            return this.turnCount;
        }

        public void setTurnCount(int val) {
            this.turnCount = val;
        }

        @Override
        public String toString() {
            String str = super.toString();
            str = str.substring(0, str.length() - 2);
            str = str + String.format(", turns=%d]\n", this.availableTurns);
            return str;
        }
    }
}

